/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.entities;

import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.linkable.LinkableTypes;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ;2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003:\u0001;B\u0019\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0014\u0010\"\u001a\u00020\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\b\u0010$\u001a\u00020\u001fH\u0014J\b\u0010%\u001a\u00020\u0000H\u0016J\u0012\u0010&\u001a\f\u0012\u0004\u0012\u00020\u0000\u0012\u0002\b\u00030'H\u0016J\u0014\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010(\u001a\u00020)H\u0016J\u0014\u0010*\u001a\u00020)2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0010\u0010+\u001a\n -*\u0004\u0018\u00010,0,H\u0016J\u001c\u0010.\u001a\u00020\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010/\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u00020)H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u000e\u00102\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)J\u0014\u00102\u001a\u00020\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\b\u00103\u001a\u00020\u000fH\u0016J\b\u00104\u001a\u00020\u001fH\u0002J\b\u00105\u001a\u00020\u001fH\u0016J\u001c\u00106\u001a\u00020\u001f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u00107\u001a\u00020\u000fH\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0016R\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00172\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\u00a8\u0006<"}, d2={"Lram/talia/hexal/common/entities/LinkableEntity;", "Lnet/minecraft/world/entity/Entity;", "Lram/talia/hexal/api/linkable/ILinkable;", "Lram/talia/hexal/api/linkable/ILinkable$IRenderCentre;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "asSpellResult", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "getAsSpellResult", "()Ljava/util/List;", "isFirstTick", "", "()Z", "setFirstTick", "(Z)V", "lazyLinked", "Lram/talia/hexal/api/linkable/ILinkable$LazyILinkableList;", "lazyRenderLinks", "value", "", "linked", "getLinked", "setLinked", "(Ljava/util/List;)V", "renderLinks", "getRenderLinks", "addAdditionalSaveData", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addRenderLink", "other", "defineSynchedData", "get", "getLinkableType", "Lram/talia/hexal/api/linkable/LinkableRegistry$LinkableType;", "index", "", "getLinkedIndex", "getPos", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "link", "linkOther", "numLinked", "readAdditionalSaveData", "removeRenderLink", "shouldRemove", "syncRenderLinks", "tick", "unlink", "unlinkOther", "writeToNbt", "Lnet/minecraft/nbt/Tag;", "writeToSync", "Companion", "hexal-forge-1.18.2"})
public abstract class LinkableEntity
extends Entity
implements ILinkable<LinkableEntity>,
ILinkable.IRenderCentre {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ILinkable.LazyILinkableList lazyLinked;
    @Nullable
    private final ILinkable.LazyILinkableList lazyRenderLinks;
    private boolean isFirstTick;
    @NotNull
    private static final EntityDataAccessor<CompoundTag> RENDER_LINKS;
    @NotNull
    public static final String TAG_LINKED = "linked";
    @NotNull
    public static final String TAG_RENDER_LINKS = "render_link_list";

    public LinkableEntity(@NotNull EntityType<?> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.lazyLinked = level.f_46443_ ? null : new ILinkable.LazyILinkableList((ServerLevel)level);
        this.lazyRenderLinks = level.f_46443_ ? null : new ILinkable.LazyILinkableList((ServerLevel)level);
        this.isFirstTick = true;
    }

    @Override
    @NotNull
    public List<SpellDatum<?>> getAsSpellResult() {
        Object[] objectArray = new Object[]{this};
        return OperatorUtils.spellListOf((Object[])objectArray);
    }

    @NotNull
    public final List<ILinkable<?>> getLinked() {
        if (this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.linked should only be accessed on server.");
        }
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyLinked;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        return lazyILinkableList.get();
    }

    public final void setLinked(@NotNull List<ILinkable<?>> value) {
        block0: {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ILinkable.LazyILinkableList lazyILinkableList = this.lazyLinked;
            if (lazyILinkableList == null) break block0;
            lazyILinkableList.set(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ILinkable.IRenderCentre> getRenderLinks() {
        List list;
        List list2;
        if (!this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.renderLinks should only be accessed on client.");
        }
        Tag tag = ((CompoundTag)this.f_19804_.m_135370_(RENDER_LINKS)).m_128423_(TAG_RENDER_LINKS);
        if (tag != null && (tag = NBTHelper.getAsList((Tag)tag)) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)tag;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ILinkable.IRenderCentre it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Tag it = (Tag)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                CompoundTag compoundTag = NBTHelper.getAsCompound((Tag)it);
                Level level = this.f_19853_;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
                if (LinkableRegistry.fromSync(compoundTag, level) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        if ((list = TypeIntrinsics.asMutableList(list2)) == null) {
            list = new ArrayList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void syncRenderLinks() {
        Collection<CompoundTag> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.syncRenderLinks should only be accessed on server.");
        }
        CompoundTag compound = new CompoundTag();
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        Iterable iterable = (Iterable)lazyILinkableList.get();
        String string = TAG_RENDER_LINKS;
        CompoundTag compoundTag = compound;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ILinkable iLinkable = (ILinkable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LinkableRegistry.wrapSync(it));
        }
        collection = (List)destination$iv$iv;
        compoundTag.m_128365_(string, (Tag)HexalNBTHelperKt.toNbtListTag((List<? extends Tag>)collection));
        this.f_19804_.m_135381_(RENDER_LINKS, (Object)compound);
    }

    private final void addRenderLink(ILinkable<?> other) {
        if (this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.addRenderLink should only be accessed on server.");
        }
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        lazyILinkableList.get().add(other);
        this.syncRenderLinks();
    }

    private final void removeRenderLink(ILinkable<?> other) {
        if (this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.removeRenderLink should only be accessed on server.");
        }
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        lazyILinkableList.get().remove(other);
        this.syncRenderLinks();
    }

    public final void removeRenderLink(int index) {
        if (this.f_19853_.f_46443_) {
            throw new Exception("LinkableEntity.removeRenderLink should only be accessed on server.");
        }
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        lazyILinkableList.get().remove(index);
        this.syncRenderLinks();
    }

    @Override
    @NotNull
    public LinkableEntity get() {
        return this;
    }

    @Override
    @NotNull
    public LinkableRegistry.LinkableType<LinkableEntity, ?> getLinkableType() {
        return LinkableTypes.INSTANCE.getLINKABLE_ENTITY_TYPE();
    }

    @Override
    public Vec3 getPos() {
        return this.m_20182_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldRemove() {
        if (!this.m_146910_()) return false;
        Entity.RemovalReason removalReason = this.m_146911_();
        if (removalReason == null) return false;
        if (!removalReason.m_146965_()) return false;
        return true;
    }

    @Override
    public void link(@NotNull ILinkable<?> other, boolean linkOther) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.f_19853_.f_46443_) {
            HexalAPI.LOGGER.info("wisp " + this.f_19820_ + " had linkWisp called in a clientside context.");
            return;
        }
        if (this.getLinked().contains(other) || other instanceof LinkableEntity && this.f_19820_.equals(((LinkableEntity)other).f_19820_)) {
            return;
        }
        HexalAPI.LOGGER.info("adding " + other + " to " + this.f_19820_ + "'s links.");
        this.getLinked().add(other);
        if (linkOther) {
            HexalAPI.LOGGER.info("adding " + other + " to " + this.f_19820_ + "'s render links.");
            this.addRenderLink(other);
        }
        if (linkOther) {
            other.link(this, false);
        }
    }

    @Override
    public void unlink(@NotNull ILinkable<?> other, boolean unlinkOther) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.f_19853_.f_46443_) {
            HexalAPI.LOGGER.info("linkable " + this.f_19820_ + " had unlink called in a clientside context.");
            return;
        }
        HexalAPI.LOGGER.info("unlinking LinkableEntity " + this.f_19820_ + " from " + other);
        this.getLinked().remove(other);
        this.removeRenderLink(other);
        if (unlinkOther) {
            other.unlink(this, false);
        }
    }

    @Override
    @NotNull
    public ILinkable<?> getLinked(int index) {
        if (this.f_19853_.f_46443_) {
            HexalAPI.LOGGER.info("linkable " + this.f_19820_ + " had getLinked called in a clientside context.");
        }
        return this.getLinked().get(index);
    }

    @Override
    public int getLinkedIndex(@NotNull ILinkable<?> linked) {
        Intrinsics.checkNotNullParameter(linked, (String)TAG_LINKED);
        return this.getLinked().indexOf(linked);
    }

    @Override
    public int numLinked() {
        return this.getLinked().size();
    }

    @Override
    @NotNull
    public Tag writeToNbt() {
        IntArrayTag intArrayTag = NbtUtils.m_129226_((UUID)this.f_19820_);
        Intrinsics.checkNotNullExpressionValue((Object)intArrayTag, (String)"createUUID(uuid)");
        return (Tag)intArrayTag;
    }

    @Override
    @NotNull
    public Tag writeToSync() {
        IntTag intTag = IntTag.m_128679_((int)this.m_142049_());
        Intrinsics.checkNotNullExpressionValue((Object)intTag, (String)"valueOf(id)");
        return (Tag)intTag;
    }

    public final boolean isFirstTick() {
        return this.isFirstTick;
    }

    public final void setFirstTick(boolean bl) {
        this.isFirstTick = bl;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.isFirstTick) {
            this.syncRenderLinks();
        }
        this.isFirstTick = false;
        for (int i = this.getLinked().size() - 1; -1 < i; --i) {
            if (!this.getLinked().get(i).shouldRemove() && this.isInRange(this.getLinked().get(i))) continue;
            ILinkable.DefaultImpls.unlink$default(this, this.getLinked().get(i), false, 2, null);
        }
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        ListTag renderLinkedTag;
        ListTag linkedTag;
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Tag tag = compound.m_128423_(TAG_LINKED);
        ListTag listTag = linkedTag = tag instanceof ListTag ? (ListTag)tag : null;
        if (linkedTag == null) {
            ILinkable.LazyILinkableList lazyILinkableList = this.lazyLinked;
            Intrinsics.checkNotNull((Object)lazyILinkableList);
            lazyILinkableList.set((List)new ArrayList());
        } else {
            ILinkable.LazyILinkableList lazyILinkableList = this.lazyLinked;
            Intrinsics.checkNotNull((Object)lazyILinkableList);
            lazyILinkableList.set((Tag)linkedTag);
        }
        tag = compound.m_128423_(TAG_RENDER_LINKS);
        ListTag listTag2 = renderLinkedTag = tag instanceof ListTag ? (ListTag)tag : null;
        if (renderLinkedTag == null) {
            ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
            Intrinsics.checkNotNull((Object)lazyILinkableList);
            lazyILinkableList.set((List)new ArrayList());
        } else {
            ILinkable.LazyILinkableList lazyILinkableList = this.lazyRenderLinks;
            Intrinsics.checkNotNull((Object)lazyILinkableList);
            lazyILinkableList.set((Tag)renderLinkedTag);
        }
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        ILinkable.LazyILinkableList lazyILinkableList = this.lazyLinked;
        Intrinsics.checkNotNull((Object)lazyILinkableList);
        compound.m_128365_(TAG_LINKED, lazyILinkableList.getUnloaded());
        ILinkable.LazyILinkableList lazyILinkableList2 = this.lazyRenderLinks;
        Intrinsics.checkNotNull((Object)lazyILinkableList2);
        compound.m_128365_(TAG_RENDER_LINKS, lazyILinkableList2.getUnloaded());
    }

    protected void m_8097_() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(TAG_RENDER_LINKS, (Tag)new ListTag());
        this.f_19804_.m_135372_(RENDER_LINKS, (Object)new CompoundTag());
    }

    @Override
    public boolean isInRange(@NotNull ILinkable<?> other) {
        return ILinkable.DefaultImpls.isInRange(this, other);
    }

    @Override
    @NotNull
    public List<Component> transmittingTargetReturnDisplay() {
        return ILinkable.DefaultImpls.transmittingTargetReturnDisplay(this);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(LinkableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(LinkableEntity:\u2026Serializers.COMPOUND_TAG)");
        RENDER_LINKS = entityDataAccessor;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lram/talia/hexal/common/entities/LinkableEntity$Companion;", "", "()V", "RENDER_LINKS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/nbt/CompoundTag;", "getRENDER_LINKS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "TAG_LINKED", "", "TAG_RENDER_LINKS", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<CompoundTag> getRENDER_LINKS() {
            return RENDER_LINKS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

