/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.entities;

import at.petrak.hexcasting.api.spell.SpellDatum;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.api.nbt.SerialisedIotaList;
import ram.talia.hexal.api.spell.casting.WispCastingManager;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.common.lib.HexalEntities;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B?\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0004J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020!J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dJ \u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010)\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lram/talia/hexal/common/entities/ProjectileWisp;", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "pos", "Lnet/minecraft/world/phys/Vec3;", "vel", "caster", "Lnet/minecraft/world/entity/player/Player;", "media", "", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/player/Player;I)V", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/player/Player;I)V", "isAffectedByGravity", "", "()Z", "setAffectedByGravity", "(Z)V", "canHitEntity", "entity", "Lnet/minecraft/world/entity/Entity;", "castCallback", "", "result", "Lram/talia/hexal/api/spell/casting/WispCastingManager$WispCastResult;", "findHitEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "start", "end", "getHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "maxSqrCastingDistance", "", "move", "onHit", "Lnet/minecraft/world/phys/HitResult;", "onHitBlock", "onHitEntity", "traceAnyHit", "raytraceResult", "Companion", "hexal-forge-1.18.2"})
public class ProjectileWisp
extends BaseCastingWisp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isAffectedByGravity;
    public static final int CASTING_SCHEDULE_PRIORITY = 0;
    public static final double CASTING_RADIUS = 4.0;

    public final boolean isAffectedByGravity() {
        return this.isAffectedByGravity;
    }

    public final void setAffectedByGravity(boolean bl) {
        this.isAffectedByGravity = bl;
    }

    public ProjectileWisp(@NotNull EntityType<? extends BaseCastingWisp> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.isAffectedByGravity = true;
    }

    public ProjectileWisp(@NotNull EntityType<? extends ProjectileWisp> entityType, @NotNull Level world, @NotNull Vec3 pos, @NotNull Vec3 vel, @NotNull Player caster, int media) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        super(entityType, world, pos, caster, media);
        this.isAffectedByGravity = true;
        this.m_20256_(vel);
    }

    public ProjectileWisp(@NotNull Level world, @NotNull Vec3 pos, @NotNull Vec3 vel, @NotNull Player caster, int media) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        EntityType<ProjectileWisp> entityType = HexalEntities.PROJECTILE_WISP;
        Intrinsics.checkNotNullExpressionValue(entityType, (String)"PROJECTILE_WISP");
        super(entityType, world, pos, caster, media);
        this.isAffectedByGravity = true;
        this.m_20256_(vel);
    }

    @Override
    public void move() {
        if (this.isAffectedByGravity) {
            Vec3 vec3 = this.m_20184_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"deltaMovement");
            this.m_20256_(OperatorUtilsKt.plus(vec3, new Vec3(0.0, -0.05, 0.0)));
        }
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        Vec3 vec32 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position()");
        Vec3 vec33 = this.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"deltaMovement");
        Vec3 endPos = this.traceAnyHit(vec3, OperatorUtilsKt.plus(vec32, vec33));
        this.m_146884_(endPos);
    }

    @Override
    public double maxSqrCastingDistance() {
        return 16.0;
    }

    @NotNull
    public final BlockHitResult getHitResult(@NotNull Vec3 start, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        BlockHitResult blockHitResult = this.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"level.clip(ClipContext(s\u2026ontext.Fluid.NONE, this))");
        return blockHitResult;
    }

    @Nullable
    protected final EntityHitResult findHitEntity(@NotNull Vec3 start, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), this::canHitEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean canHitEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.m_5833_()) return false;
        if (!entity.m_6084_()) return false;
        if (!entity.m_6087_()) return false;
        if (this.getCaster() == null) return true;
        Player player = this.getCaster();
        Intrinsics.checkNotNull((Object)player);
        if (player.m_20365_(entity)) return false;
        return true;
    }

    @NotNull
    public final Vec3 traceAnyHit(@NotNull Vec3 start, @NotNull Vec3 end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return this.traceAnyHit((HitResult)this.getHitResult(start, end), start, end);
    }

    @NotNull
    public final Vec3 traceAnyHit(@Nullable HitResult raytraceResult, @NotNull Vec3 start, @NotNull Vec3 end) {
        HitResult tRaytraceResult;
        EntityHitResult entityRaytraceResult;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Vec3 tEnd = end;
        if (raytraceResult != null && raytraceResult.m_6662_() != HitResult.Type.MISS) {
            Vec3 vec3 = raytraceResult.m_82450_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"raytraceResult.location");
            tEnd = vec3;
        }
        EntityHitResult entityHitResult = entityRaytraceResult = this.findHitEntity(start, tEnd);
        HitResult hitResult = tRaytraceResult = entityHitResult != null ? (HitResult)entityHitResult : raytraceResult;
        if (tRaytraceResult != null && tRaytraceResult.m_6662_() != HitResult.Type.MISS) {
            this.onHit(tRaytraceResult);
            this.f_19812_ = true;
        }
        return tEnd;
    }

    public final void onHit(@NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        HitResult.Type type = result.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
        } else if (type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
        if (type != HitResult.Type.MISS) {
            this.m_146852_(GameEvent.f_157777_, (Entity)this.getCaster());
        }
    }

    public final void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.m_146884_(result.m_82450_());
        if (this.f_19853_.f_46443_) {
            this.playTrailParticles();
        } else {
            Object[] objectArray = new SpellDatum[2];
            objectArray[0] = SpellDatum.Companion.make((Object)this);
            Entity entity = result.m_82443_();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"result.entity");
            objectArray[1] = SpellDatum.Companion.make((Object)entity);
            SerialisedIotaList serStack = new SerialisedIotaList(HexalNBTHelperKt.toNbtListSpellDatum(CollectionsKt.mutableListOf((Object[])objectArray)));
            BaseCastingWisp.scheduleCast$default(this, 0, this.getSerHex(), serStack, null, 8, null);
        }
    }

    public final void onHitBlock(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.m_146884_(result.m_82450_());
        if (this.f_19853_.f_46443_) {
            this.playTrailParticles();
        } else {
            Object[] objectArray = new SpellDatum[2];
            objectArray[0] = SpellDatum.Companion.make((Object)this);
            Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)result.m_82425_()));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(result.blockPos)");
            objectArray[1] = SpellDatum.Companion.make((Object)vec3);
            SerialisedIotaList serStack = new SerialisedIotaList(HexalNBTHelperKt.toNbtListSpellDatum(CollectionsKt.mutableListOf((Object[])objectArray)));
            BaseCastingWisp.scheduleCast$default(this, 0, this.getSerHex(), serStack, null, 8, null);
        }
    }

    @Override
    public void castCallback(@NotNull WispCastingManager.WispCastResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.castCallback(result);
        this.m_146870_();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lram/talia/hexal/common/entities/ProjectileWisp$Companion;", "", "()V", "CASTING_RADIUS", "", "CASTING_SCHEDULE_PRIORITY", "", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

