/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.entities;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.Widget;
import com.mojang.datafixers.util.Either;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.common.entities.BaseWisp;
import ram.talia.hexal.common.lib.HexalEntities;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001eH\u0014J\u001c\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020\u001eJ\f\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0016J\b\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0014\u0010/\u001a\u00020\u001e2\n\u00100\u001a\u0006\u0012\u0002\b\u00030,H\u0016J\b\u00101\u001a\u00020\u001eH\u0016R$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lram/talia/hexal/common/entities/WanderingWisp;", "Lram/talia/hexal/common/entities/BaseWisp;", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "entityType", "Lnet/minecraft/world/entity/EntityType;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "value", "acceleration", "getAcceleration", "()Lnet/minecraft/world/phys/Vec3;", "setAcceleration", "(Lnet/minecraft/world/phys/Vec3;)V", "<anonymous parameter 0>", "", "media", "getMedia", "()I", "setMedia", "(I)V", "startTick", "", "getStartTick", "()J", "setStartTick", "(J)V", "addAdditionalSaveData", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "defineSynchedData", "fightConsume", "", "consumer", "Lcom/mojang/datafixers/util/Either;", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "Lnet/minecraft/server/level/ServerPlayer;", "maxSqrLinkRange", "", "move", "nextReceivedIota", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "numRemainingIota", "readAdditionalSaveData", "receiveIota", "iota", "tick", "Companion", "hexal-forge-1.18.2"})
public final class WanderingWisp
extends BaseWisp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startTick;
    @NotNull
    private static final EntityDataAccessor<Float> ACCELERATION_X;
    @NotNull
    private static final EntityDataAccessor<Float> ACCELERATION_Y;
    @NotNull
    private static final EntityDataAccessor<Float> ACCELERATION_Z;
    @NotNull
    public static final String TAG_ACCELERATION_X = "acceleration_x";
    @NotNull
    public static final String TAG_ACCELERATION_Y = "acceleration_y";
    @NotNull
    public static final String TAG_ACCELERATION_Z = "acceleration_z";
    @NotNull
    public static final String TAG_START_TICK = "start_tick";
    public static final int MAX_TICKS_ALIVE = 300;
    public static final int MIN_MEDIA = 100000;
    public static final int MAX_MEDIA = 250000;

    public WanderingWisp(@NotNull EntityType<? extends WanderingWisp> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super((EntityType<? extends BaseWisp>)entityType, world);
    }

    @Override
    public int getMedia() {
        return 100000 + 150000 * this.f_19797_ / 300;
    }

    @Override
    public void setMedia(int n) {
    }

    @NotNull
    public final Vec3 getAcceleration() {
        return new Vec3((double)((Number)this.f_19804_.m_135370_(ACCELERATION_X)).floatValue(), (double)((Number)this.f_19804_.m_135370_(ACCELERATION_Y)).floatValue(), (double)((Number)this.f_19804_.m_135370_(ACCELERATION_Z)).floatValue());
    }

    public final void setAcceleration(@NotNull Vec3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.f_19804_.m_135381_(ACCELERATION_X, (Object)Float.valueOf((float)value.f_82479_));
        this.f_19804_.m_135381_(ACCELERATION_Y, (Object)Float.valueOf((float)value.f_82480_));
        this.f_19804_.m_135381_(ACCELERATION_Z, (Object)Float.valueOf((float)value.f_82481_));
    }

    public final long getStartTick() {
        return this.startTick;
    }

    public final void setStartTick(long l) {
        this.startTick = l;
    }

    @Override
    public double maxSqrLinkRange() {
        return 16.0;
    }

    @Override
    public void receiveIota(@NotNull SpellDatum<?> iota) {
        Intrinsics.checkNotNullParameter(iota, (String)"iota");
    }

    @Override
    @NotNull
    public SpellDatum<?> nextReceivedIota() {
        return SpellDatum.Companion.make((Object)Widget.NULL);
    }

    @Override
    public int numRemainingIota() {
        return 0;
    }

    @Override
    public boolean fightConsume(@NotNull Either<BaseCastingWisp, ServerPlayer> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return false;
    }

    public WanderingWisp(@NotNull Level world, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        EntityType<WanderingWisp> entityType = HexalEntities.WANDERING_WISP;
        Intrinsics.checkNotNullExpressionValue(entityType, (String)"WANDERING_WISP");
        this((EntityType<? extends WanderingWisp>)entityType, world);
        this.m_146884_(pos);
        this.startTick = world.m_46467_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() > this.startTick + (long)300) {
            this.m_146870_();
        }
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        this.setOldPos(vec3);
        this.move();
        if (this.f_19853_.f_46443_) {
            FrozenColorizer colouriser = FrozenColorizer.fromNBT((CompoundTag)((CompoundTag)this.f_19804_.m_135370_(BaseWisp.Companion.getCOLOURISER())));
            Intrinsics.checkNotNullExpressionValue((Object)colouriser, (String)"colouriser");
            this.playWispParticles(colouriser);
            this.playTrailParticles(colouriser);
            this.playAllLinkParticles();
        }
    }

    public final void move() {
        Vec3 vec3 = this.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"deltaMovement");
        Vec3 adjDelta = this.maxMove(vec3);
        double dX = this.m_20184_().f_82479_;
        double dY = this.m_20184_().f_82480_;
        double dZ = this.m_20184_().f_82481_;
        double aX = this.getAcceleration().f_82479_;
        double aY = this.getAcceleration().f_82480_;
        double aZ = this.getAcceleration().f_82481_;
        if (Math.abs(adjDelta.f_82479_ - dX) > 1.0E-4) {
            dX = -dX;
            aX = -aX;
        }
        if (Math.abs(adjDelta.f_82480_ - dY) > 1.0E-4) {
            dY = -dY;
            aY = -aY;
        }
        if (Math.abs(adjDelta.f_82481_ - dZ) > 1.0E-4) {
            dZ = -dZ;
            aZ = -aZ;
        }
        this.m_20256_(new Vec3(dX, dY, dZ));
        this.setAcceleration(new Vec3(aX, aY, aZ));
        Vec3 vec32 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position()");
        this.m_146884_(OperatorUtilsKt.plus(vec32, adjDelta));
        Vec3 vec33 = this.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"deltaMovement");
        this.m_20256_(OperatorUtilsKt.plus(vec33, this.getAcceleration()));
        this.setAcceleration(OperatorUtilsKt.plus(this.getAcceleration(), new Vec3(this.f_19796_.nextDouble(-0.005, 0.005), this.f_19796_.nextDouble(-0.005, 0.005), this.f_19796_.nextDouble(-0.005, 0.005))));
        this.setAcceleration(new Vec3(RangesKt.coerceIn((double)this.getAcceleration().f_82479_, (double)-0.0125, (double)0.0125), RangesKt.coerceIn((double)this.getAcceleration().f_82480_, (double)-0.0125, (double)0.0125), RangesKt.coerceIn((double)this.getAcceleration().f_82481_, (double)-0.0125, (double)0.0125)));
        this.m_20256_(new Vec3(RangesKt.coerceIn((double)this.m_20184_().f_82479_, (double)-0.05, (double)0.05), RangesKt.coerceIn((double)this.m_20184_().f_82480_, (double)-0.05, (double)0.05), RangesKt.coerceIn((double)this.m_20184_().f_82481_, (double)-0.05, (double)0.05)));
        Vec3 vec34 = this.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"deltaMovement");
        this.setLookVector(vec34);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ACCELERATION_X, (Object)Float.valueOf(compound.m_128457_(TAG_ACCELERATION_X)));
        this.f_19804_.m_135381_(ACCELERATION_Y, (Object)Float.valueOf(compound.m_128457_(TAG_ACCELERATION_Y)));
        this.f_19804_.m_135381_(ACCELERATION_Z, (Object)Float.valueOf(compound.m_128457_(TAG_ACCELERATION_Z)));
        this.startTick = compound.m_128454_(TAG_START_TICK);
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.m_7380_(compound);
        Object object = this.f_19804_.m_135370_(ACCELERATION_X);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityData.get(ACCELERATION_X)");
        compound.m_128350_(TAG_ACCELERATION_X, ((Number)object).floatValue());
        Object object2 = this.f_19804_.m_135370_(ACCELERATION_Y);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"entityData.get(ACCELERATION_Y)");
        compound.m_128350_(TAG_ACCELERATION_Y, ((Number)object2).floatValue());
        Object object3 = this.f_19804_.m_135370_(ACCELERATION_Z);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"entityData.get(ACCELERATION_Z)");
        compound.m_128350_(TAG_ACCELERATION_Z, ((Number)object3).floatValue());
        compound.m_128356_(TAG_START_TICK, this.startTick);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACCELERATION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACCELERATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACCELERATION_Z, (Object)Float.valueOf(0.0f));
    }

    @NotNull
    public static final EntityDataAccessor<Float> getACCELERATION_X() {
        return Companion.getACCELERATION_X();
    }

    @NotNull
    public static final EntityDataAccessor<Float> getACCELERATION_Y() {
        return Companion.getACCELERATION_Y();
    }

    @NotNull
    public static final EntityDataAccessor<Float> getACCELERATION_Z() {
        return Companion.getACCELERATION_Z();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(WanderingWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(WanderingWisp::\u2026ityDataSerializers.FLOAT)");
        ACCELERATION_X = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(WanderingWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(WanderingWisp::\u2026ityDataSerializers.FLOAT)");
        ACCELERATION_Y = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(WanderingWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(WanderingWisp::\u2026ityDataSerializers.FLOAT)");
        ACCELERATION_Z = entityDataAccessor3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lram/talia/hexal/common/entities/WanderingWisp$Companion;", "", "()V", "ACCELERATION_X", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getACCELERATION_X$annotations", "getACCELERATION_X", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "ACCELERATION_Y", "getACCELERATION_Y$annotations", "getACCELERATION_Y", "ACCELERATION_Z", "getACCELERATION_Z$annotations", "getACCELERATION_Z", "MAX_MEDIA", "", "MAX_TICKS_ALIVE", "MIN_MEDIA", "TAG_ACCELERATION_X", "", "TAG_ACCELERATION_Y", "TAG_ACCELERATION_Z", "TAG_START_TICK", "hexal-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Float> getACCELERATION_X() {
            return ACCELERATION_X;
        }

        @JvmStatic
        public static /* synthetic */ void getACCELERATION_X$annotations() {
        }

        @NotNull
        public final EntityDataAccessor<Float> getACCELERATION_Y() {
            return ACCELERATION_Y;
        }

        @JvmStatic
        public static /* synthetic */ void getACCELERATION_Y$annotations() {
        }

        @NotNull
        public final EntityDataAccessor<Float> getACCELERATION_Z() {
            return ACCELERATION_Z;
        }

        @JvmStatic
        public static /* synthetic */ void getACCELERATION_Z$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

