/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.casting.RegisterPatterns;
import ram.talia.hexal.common.lib.HexalBlockEntities;
import ram.talia.hexal.common.lib.HexalBlocks;
import ram.talia.hexal.common.lib.HexalEntities;
import ram.talia.hexal.common.lib.HexalSounds;
import ram.talia.hexal.common.lib.feature.HexalConfiguredFeatures;
import ram.talia.hexal.common.lib.feature.HexalFeatures;
import ram.talia.hexal.common.lib.feature.HexalPlacedFeatures;
import ram.talia.hexal.common.recipe.HexalRecipeSerializers;
import ram.talia.hexal.forge.ForgeHexalClientInitializer;
import ram.talia.hexal.forge.cap.CapSyncers;
import ram.talia.hexal.forge.datagen.HexalForgeDataGenerators;
import ram.talia.hexal.forge.eventhandlers.BiomeGenerationEventHandler;
import ram.talia.hexal.forge.eventhandlers.EverbookEventHandler;
import ram.talia.hexal.forge.eventhandlers.PlayerLinkstoreEventHandler;
import ram.talia.hexal.forge.eventhandlers.WispCastingMangerEventHandler;
import ram.talia.hexal.forge.network.ForgePacketHandler;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hexal")
public class ForgeHexalInitializer {
    public ForgeHexalInitializer() {
        HexalAPI.LOGGER.info("Hello Forge World!");
        ForgeHexalInitializer.initConfig();
        ForgeHexalInitializer.initRegistry();
        ForgeHexalInitializer.initListeners();
    }

    private static void initConfig() {
    }

    private static void initRegistry() {
        ForgeHexalInitializer.bind(ForgeRegistries.FEATURES, HexalFeatures::registerFeatures);
        ForgeHexalInitializer.bind(BuiltinRegistries.f_123861_, HexalConfiguredFeatures::registerConfiguredFeatures);
        ForgeHexalInitializer.bind(BuiltinRegistries.f_194653_, HexalPlacedFeatures::registerPlacedFeatures);
        ForgeHexalInitializer.bind(ForgeRegistries.SOUND_EVENTS, HexalSounds::registerSounds);
        ForgeHexalInitializer.bind(ForgeRegistries.BLOCKS, HexalBlocks::registerBlocks);
        ForgeHexalInitializer.bind(ForgeRegistries.ITEMS, HexalBlocks::registerBlockItems);
        ForgeHexalInitializer.bind(ForgeRegistries.BLOCK_ENTITIES, HexalBlockEntities::registerBlockEntities);
        ForgeHexalInitializer.bind(ForgeRegistries.ENTITIES, HexalEntities::registerEntities);
        ForgeHexalInitializer.bind(ForgeRegistries.RECIPE_SERIALIZERS, HexalRecipeSerializers::registerSerializers);
    }

    private static void initListeners() {
        IEventBus modBus = ForgeHexalInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.register(ForgeHexalClientInitializer.class);
        modBus.addListener(evt -> evt.enqueueWork(() -> ForgePacketHandler.init()));
        modBus.addListener(evt -> evt.enqueueWork(RegisterPatterns::registerPatterns));
        modBus.addGenericListener(Item.class, evt -> HexalRecipeSerializers.registerTypes());
        modBus.register(HexalForgeDataGenerators.class);
        evBus.register(WispCastingMangerEventHandler.class);
        evBus.register(CapSyncers.class);
        evBus.register(PlayerLinkstoreEventHandler.class);
        evBus.register(EverbookEventHandler.class);
        evBus.register(BiomeGenerationEventHandler.class);
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeHexalInitializer.getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            IForgeRegistry forgeRegistry = event.getRegistry();
            source.accept((t, rl) -> {
                t.setRegistryName(rl);
                forgeRegistry.register(t);
            });
        });
    }

    private static <T> void bind(Registry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        source.accept((t, id) -> Registry.m_122965_((Registry)registry, (ResourceLocation)id, (Object)t));
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

