/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.cap;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.linkable.PlayerLinkstore;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.forge.network.MsgPlayerAddRenderLinkAck;
import ram.talia.hexal.forge.network.MsgPlayerClearRenderLinksAck;
import ram.talia.hexal.forge.network.MsgPlayerRemoveRenderLinkAck;
import ram.talia.hexal.forge.network.MsgPlayerRenderLinksAck;
import ram.talia.hexal.xplat.IXplatAbstractions;

public class CapSyncers {
    @SubscribeEvent
    public static void syncDataOnLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer loggedInPlayer = (ServerPlayer)player;
        List allPlayers = loggedInPlayer.f_19853_.m_6907_();
        for (Player player2 : allPlayers) {
            CapSyncers.syncAllRenderLinks((ServerPlayer)player2, loggedInPlayer);
            if (player2.m_142081_() == loggedInPlayer.m_142081_()) continue;
            CapSyncers.syncAllRenderLinks(loggedInPlayer, (ServerPlayer)player2);
        }
    }

    @SubscribeEvent
    public static void syncDataOnRejoin(PlayerEvent.PlayerRespawnEvent evt) {
        Player player = evt.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer loggedInPlayer = (ServerPlayer)player;
        List allPlayers = loggedInPlayer.f_19853_.m_6907_();
        for (Player player2 : allPlayers) {
            CapSyncers.syncAllRenderLinks(loggedInPlayer, (ServerPlayer)player2);
            if (player2.m_142081_() == loggedInPlayer.m_142081_()) continue;
            CapSyncers.syncAllRenderLinks((ServerPlayer)player2, loggedInPlayer);
        }
    }

    public static void syncAllRenderLinks(ServerPlayer packetTarget, ServerPlayer syncedPlayer) {
        PlayerLinkstore linkstore = IXplatAbstractions.INSTANCE.getLinkstore(syncedPlayer);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(packetTarget, new MsgPlayerRenderLinksAck(syncedPlayer.m_142081_(), HexalNBTHelperKt.toSyncTagILinkable(linkstore.getRenderLinks())));
    }

    public static void syncAddRenderLink(ServerPlayer packetTarget, ServerPlayer syncedPlayer, ILinkable<?> link) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(packetTarget, new MsgPlayerAddRenderLinkAck(syncedPlayer.m_142081_(), LinkableRegistry.wrapSync(link)));
    }

    public static void syncRemoveRenderLink(ServerPlayer packetTarget, ServerPlayer syncedPlayer, ILinkable<?> link) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(packetTarget, new MsgPlayerRemoveRenderLinkAck(syncedPlayer.m_142081_(), LinkableRegistry.wrapSync(link)));
    }

    public static void syncClearRenderLinks(ServerPlayer packetTarget, ServerPlayer syncedPlayer) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(packetTarget, new MsgPlayerClearRenderLinksAck(syncedPlayer.m_142081_()));
    }
}

