/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.eventhandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.PlayerLinkstore;
import ram.talia.hexal.client.RenderHelperKt;

public class PlayerLinkstoreEventHandler {
    private static final String TAG_PLAYER_LINKSTORE = "player_linkstore";
    private static final Map<UUID, PlayerLinkstore> linkstores = new HashMap<UUID, PlayerLinkstore>();
    private static final Map<UUID, List<ILinkable.IRenderCentre>> renderLinks = new HashMap<UUID, List<ILinkable.IRenderCentre>>();

    public static List<ILinkable.IRenderCentre> getRenderLinks(Player player) {
        return PlayerLinkstoreEventHandler.getRenderLinks(player.m_142081_());
    }

    public static List<ILinkable.IRenderCentre> getRenderLinks(UUID player) {
        return renderLinks.get(player);
    }

    public static List<ILinkable.IRenderCentre> setRenderLinks(Player player, List<ILinkable.IRenderCentre> newRenderLinks) {
        return PlayerLinkstoreEventHandler.setRenderLinks(player.m_142081_(), newRenderLinks);
    }

    public static List<ILinkable.IRenderCentre> setRenderLinks(UUID player, List<ILinkable.IRenderCentre> newRenderLinks) {
        return renderLinks.put(player, newRenderLinks);
    }

    public static PlayerLinkstore getLinkstore(ServerPlayer player) {
        PlayerLinkstore linkstore = linkstores.get(player.m_142081_());
        if (linkstore == null) {
            linkstore = PlayerLinkstoreEventHandler.loadLinkstore(player);
            linkstores.put(player.m_142081_(), linkstore);
        }
        return linkstore;
    }

    private static PlayerLinkstore loadLinkstore(ServerPlayer player) {
        PlayerLinkstore linkstore = new PlayerLinkstore(player);
        linkstore.loadAdditionalData(player.getPersistentData().m_128469_(TAG_PLAYER_LINKSTORE));
        return linkstore;
    }

    public static ILinkable<?> getTransmittingTo(ServerPlayer player) {
        return PlayerLinkstoreEventHandler.getLinkstore(player).getTransmittingTo();
    }

    public static void setTransmittingTo(ServerPlayer player, int to) {
        PlayerLinkstoreEventHandler.getLinkstore(player).setTransmittingTo(to);
    }

    public static void resetTransmittingTo(ServerPlayer player) {
        PlayerLinkstoreEventHandler.getLinkstore(player).resetTransmittingTo();
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        linkstores.put(player.m_142081_(), PlayerLinkstoreEventHandler.loadLinkstore(player));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        renderLinks.computeIfAbsent(event.getPlayer().m_142081_(), k -> new ArrayList());
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        CompoundTag tag = new CompoundTag();
        PlayerLinkstoreEventHandler.getLinkstore(player).saveAdditionalData(tag);
        player.getPersistentData().m_128365_(TAG_PLAYER_LINKSTORE, (Tag)tag);
        linkstores.remove(player.m_142081_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        renderLinks.remove(event.getPlayer().m_142081_());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) throws Exception {
        if (event.side == LogicalSide.CLIENT) {
            PlayerLinkstoreEventHandler.clientTick(event.player);
        } else {
            PlayerLinkstoreEventHandler.serverTick((ServerPlayer)event.player);
        }
    }

    private static void serverTick(ServerPlayer player) {
        linkstores.get(player.m_142081_()).pruneLinks();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Player player) throws Exception {
        if (!player.f_19853_.f_46443_) {
            throw new Exception("PlayerLinkstoreEventHander.clientTick can only be called on the client");
        }
        PlayerLinkstore.RenderCentre ownerRenderCentre = new PlayerLinkstore.RenderCentre(player);
        List<ILinkable.IRenderCentre> theseLinks = PlayerLinkstoreEventHandler.getRenderLinks(player);
        if (theseLinks == null) {
            return;
        }
        Iterator<ILinkable.IRenderCentre> iter = theseLinks.iterator();
        while (iter.hasNext()) {
            ILinkable.IRenderCentre link = iter.next();
            if (link.shouldRemove()) {
                iter.remove();
                continue;
            }
            RenderHelperKt.playLinkParticles(ownerRenderCentre, link, player.m_21187_(), player.f_19853_);
        }
    }
}

