/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.eventhandlers;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.spell.casting.WispCastingManager;
import ram.talia.hexal.common.entities.BaseCastingWisp;

public class WispCastingMangerEventHandler {
    private static final String TAG_CASTING_MANAGER = "hexal:casting_manager";
    private static final String TAG_SEON = "hexal:seon";
    private static final Map<UUID, WispCastingManager> castingManagers = new HashMap<UUID, WispCastingManager>();
    private static final Map<UUID, WeakReference<BaseCastingWisp>> seons = new HashMap<UUID, WeakReference<BaseCastingWisp>>();

    public static WispCastingManager getCastingManager(ServerPlayer serverPlayer) {
        WispCastingManager manager = castingManagers.get(serverPlayer.m_142081_());
        if (manager == null) {
            manager = WispCastingMangerEventHandler.loadCastingManager(serverPlayer);
            castingManagers.put(serverPlayer.m_142081_(), manager);
        }
        return manager;
    }

    private static WispCastingManager loadCastingManager(ServerPlayer player) {
        WispCastingManager manager = new WispCastingManager(player);
        manager.readFromNbt(player.getPersistentData().m_128469_(TAG_CASTING_MANAGER), player.m_183503_());
        return manager;
    }

    @Nullable
    public static BaseCastingWisp getSeon(ServerPlayer player) {
        return (BaseCastingWisp)seons.get(player.m_142081_()).get();
    }

    public static void setSeon(ServerPlayer player, BaseCastingWisp wisp) {
        BaseCastingWisp old = (BaseCastingWisp)seons.get(player.m_142081_()).get();
        if (old != null) {
            old.setSeon(false);
        }
        wisp.setSeon(true);
        seons.put(player.m_142081_(), new WeakReference<BaseCastingWisp>(wisp));
    }

    private static WeakReference<BaseCastingWisp> loadSeon(ServerPlayer player) {
        if (!player.getPersistentData().m_128403_(TAG_SEON)) {
            return new WeakReference<Object>(null);
        }
        Entity entity = player.m_183503_().m_8791_(player.getPersistentData().m_128342_(TAG_SEON));
        if (entity instanceof BaseCastingWisp) {
            BaseCastingWisp seon = (BaseCastingWisp)entity;
            return new WeakReference<BaseCastingWisp>(seon);
        }
        return new WeakReference<Object>(null);
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().m_183503_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        castingManagers.put(player.m_142081_(), WispCastingMangerEventHandler.loadCastingManager(player));
        seons.put(player.m_142081_(), WispCastingMangerEventHandler.loadSeon(player));
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().m_183503_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        CompoundTag tag = new CompoundTag();
        WispCastingMangerEventHandler.getCastingManager(player).writeToNbt(tag);
        player.getPersistentData().m_128365_(TAG_CASTING_MANAGER, (Tag)tag);
        BaseCastingWisp seon = (BaseCastingWisp)seons.get(player.m_142081_()).get();
        if (seon != null) {
            player.getPersistentData().m_128362_(TAG_SEON, seon.m_142081_());
        }
        castingManagers.remove(player.m_142081_());
        seons.remove(player.m_142081_());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        WispCastingMangerEventHandler.getCastingManager(player).executeCasts();
    }
}

