/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.mixin;

import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.spell.casting.IMixinCastingContext;
import ram.talia.hexal.common.casting.Patterns;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.xplat.IXplatAbstractions;

@Mixin(value={CastingHarness.class})
public abstract class MixinCastingHarness {
    private final CastingHarness harness = (CastingHarness)this;
    @Shadow(remap=false)
    private boolean escapeNext;

    @Redirect(method={"updateWithPattern"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), remap=false)
    private boolean updateWithPatternWisp(List<OperatorSideEffect> sideEffects, Object o) {
        if (o instanceof OperatorSideEffect.Particles) {
            OperatorSideEffect.Particles particles = (OperatorSideEffect.Particles)o;
            CastingContext ctx = ((CastingHarness)this).getCtx();
            IMixinCastingContext ctxi = (IMixinCastingContext)ctx;
            if (!ctxi.hasWisp()) {
                return sideEffects.add((OperatorSideEffect)particles);
            }
            return false;
        }
        return sideEffects.add((OperatorSideEffect)o);
    }

    @Inject(method={"withdrawMana"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, remap=false)
    private void withdrawManaWisp(int manaCost, boolean allowOvercast, CallbackInfoReturnable<Integer> cir) {
        if (manaCost <= 0) {
            cir.setReturnValue((Object)0);
            return;
        }
        IMixinCastingContext wispContext = (IMixinCastingContext)((CastingHarness)this).getCtx();
        BaseCastingWisp wisp = wispContext.getWisp();
        if (wisp != null) {
            int mediaAvailable = wisp.getMedia();
            int mediaToTake = Math.min(manaCost, mediaAvailable);
            wisp.addMedia(-mediaToTake);
            cir.setReturnValue((Object)(manaCost -= mediaToTake));
        }
    }

    @Inject(method={"executeIota"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, remap=false)
    private void executeIotaMacro(SpellDatum<?> iota, ServerLevel world, CallbackInfoReturnable<ControllerInfo> cir) {
        boolean transmitting;
        List<SpellDatum<?>> toExecute;
        CastingContext ctx = this.harness.getCtx();
        if (ctx.getSpellCircle() != null || ((IMixinCastingContext)ctx).hasWisp()) {
            return;
        }
        if (!ctx.isCasterEnlightened() || this.escapeNext) {
            toExecute = new ArrayList(Collections.singleton(iota));
        } else if (iota.getType() != DatumType.PATTERN || ((HexPattern)iota.getPayload()).anglesSignature().equals("qqqaw")) {
            toExecute = new ArrayList(Collections.singleton(iota));
        } else {
            HexPattern pattern = (HexPattern)iota.getPayload();
            toExecute = IXplatAbstractions.INSTANCE.getEverbookMacro(ctx.getCaster(), pattern);
            if (toExecute == null) {
                toExecute = new ArrayList(Collections.singleton(iota));
            }
        }
        boolean isUnescapedEscape = !this.escapeNext && iota.getType() == DatumType.PATTERN && ((HexPattern)iota.getPayload()).anglesSignature().equals("qqqaw");
        ILinkable<?> transmittingTo = IXplatAbstractions.INSTANCE.getPlayerTransmittingTo(ctx.getCaster());
        boolean bl = transmitting = transmittingTo != null;
        if (transmitting && !isUnescapedEscape) {
            Iterator<SpellDatum<?>> iter = toExecute.iterator();
            while (iter.hasNext()) {
                SpellDatum<?> it = iter.next();
                if (!this.escapeNext && it.getType() == DatumType.PATTERN && ((HexPattern)it.getPayload()).anglesSignature().equals(((HexPattern)Patterns.LINK_COMM_CLOSE_TRANSMIT.getFirst()).anglesSignature())) break;
                iter.remove();
                transmittingTo.receiveIota(it);
            }
            this.escapeNext = false;
        }
        boolean wasTransmitting = transmitting;
        ControllerInfo ret = this.harness.executeIotas(toExecute, world);
        transmittingTo = IXplatAbstractions.INSTANCE.getPlayerTransmittingTo(ctx.getCaster());
        transmitting = transmittingTo != null;
        boolean isEdgeTransmit = transmitting ^ wasTransmitting;
        boolean isStackClear = ret.isStackClear() && !transmitting;
        ResolvedPatternType type = transmitting && !isUnescapedEscape && !isEdgeTransmit ? ResolvedPatternType.ESCAPED : ret.getResolutionType();
        List stackDesc = transmitting ? transmittingTo.transmittingTargetReturnDisplay() : ret.getStackDesc();
        ret = ret.copy(ret.getMakesCastSound(), isStackClear, type, stackDesc);
        cir.setReturnValue((Object)ret);
    }
}

