/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.block.BlockInventoryCable;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.block.BlockInventoryCableConnectorFiltered;
import com.tom.storagemod.block.BlockInventoryCableConnectorFramed;
import com.tom.storagemod.block.BlockInventoryCableFramed;
import com.tom.storagemod.block.BlockInventoryHopperBasic;
import com.tom.storagemod.block.BlockInventoryProxy;
import com.tom.storagemod.block.BlockLevelEmitter;
import com.tom.storagemod.block.BlockOpenCrate;
import com.tom.storagemod.block.BlockPaintedTrim;
import com.tom.storagemod.block.BlockTrim;
import com.tom.storagemod.block.CraftingTerminal;
import com.tom.storagemod.block.InventoryConnector;
import com.tom.storagemod.block.StorageTerminal;
import com.tom.storagemod.gui.ContainerCraftingTerminal;
import com.tom.storagemod.gui.ContainerFiltered;
import com.tom.storagemod.gui.ContainerInventoryLink;
import com.tom.storagemod.gui.ContainerLevelEmitter;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.item.ItemAdvWirelessTerminal;
import com.tom.storagemod.item.ItemBlockPainted;
import com.tom.storagemod.item.ItemPaintKit;
import com.tom.storagemod.item.ItemWirelessTerminal;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.tile.TileEntityCraftingTerminal;
import com.tom.storagemod.tile.TileEntityInventoryCableConnector;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorFiltered;
import com.tom.storagemod.tile.TileEntityInventoryConnector;
import com.tom.storagemod.tile.TileEntityInventoryHopperBasic;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import com.tom.storagemod.tile.TileEntityLevelEmitter;
import com.tom.storagemod.tile.TileEntityOpenCrate;
import com.tom.storagemod.tile.TileEntityPainted;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="toms_storage")
public class StorageMod {
    public static final String modid = "toms_storage";
    public static InventoryConnector connector;
    public static StorageTerminal terminal;
    public static BlockTrim inventoryTrim;
    public static BlockOpenCrate openCrate;
    public static BlockPaintedTrim paintedTrim;
    public static BlockInventoryCable invCable;
    public static BlockInventoryCableFramed invCableFramed;
    public static BlockInventoryCableConnector invCableConnector;
    public static BlockInventoryCableConnectorFiltered invCableConnectorFiltered;
    public static BlockInventoryCableConnectorFramed invCableConnectorFramed;
    public static BlockInventoryProxy invProxy;
    public static CraftingTerminal craftingTerminal;
    public static BlockInventoryHopperBasic invHopperBasic;
    public static BlockLevelEmitter levelEmitter;
    public static ItemPaintKit paintingKit;
    public static ItemWirelessTerminal wirelessTerminal;
    public static ItemAdvWirelessTerminal advWirelessTerminal;
    public static BlockEntityType<TileEntityInventoryConnector> connectorTile;
    public static BlockEntityType<TileEntityStorageTerminal> terminalTile;
    public static BlockEntityType<TileEntityOpenCrate> openCrateTile;
    public static BlockEntityType<TileEntityPainted> paintedTile;
    public static BlockEntityType<TileEntityInventoryCableConnector> invCableConnectorTile;
    public static BlockEntityType<TileEntityInventoryCableConnectorFiltered> invCableConnectorFilteredTile;
    public static BlockEntityType<TileEntityInventoryProxy> invProxyTile;
    public static BlockEntityType<TileEntityCraftingTerminal> craftingTerminalTile;
    public static BlockEntityType<TileEntityInventoryHopperBasic> invHopperBasicTile;
    public static BlockEntityType<TileEntityLevelEmitter> levelEmitterTile;
    public static MenuType<ContainerStorageTerminal> storageTerminal;
    public static MenuType<ContainerCraftingTerminal> craftingTerminalCont;
    public static MenuType<ContainerFiltered> filteredConatiner;
    public static MenuType<ContainerLevelEmitter> levelEmitterConatiner;
    public static MenuType<ContainerInventoryLink> inventoryLink;
    public static final Logger LOGGER;
    public static final CreativeModeTab STORAGE_MOD_TAB;

    public StorageMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendIMC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Storage Setup starting");
        NetworkHandler.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        StorageModClient.clientSetup();
    }

    public void sendIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        STORAGE_MOD_TAB = new CreativeModeTab("toms_storage.tab"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)terminal);
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            connector = new InventoryConnector();
            terminal = new StorageTerminal();
            openCrate = new BlockOpenCrate();
            inventoryTrim = new BlockTrim();
            paintedTrim = new BlockPaintedTrim();
            invCable = new BlockInventoryCable();
            invCableFramed = new BlockInventoryCableFramed();
            invCableConnector = new BlockInventoryCableConnector();
            invCableConnectorFiltered = new BlockInventoryCableConnectorFiltered();
            invProxy = new BlockInventoryProxy();
            craftingTerminal = new CraftingTerminal();
            invHopperBasic = new BlockInventoryHopperBasic();
            levelEmitter = new BlockLevelEmitter();
            invCableConnectorFramed = new BlockInventoryCableConnectorFramed();
            blockRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{connector, terminal, openCrate, inventoryTrim, paintedTrim, invCable, invCableFramed, invCableConnector, invCableConnectorFiltered, invProxy, craftingTerminal, invHopperBasic, levelEmitter, invCableConnectorFramed});
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            paintingKit = new ItemPaintKit();
            wirelessTerminal = new ItemWirelessTerminal();
            advWirelessTerminal = new ItemAdvWirelessTerminal();
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)connector);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)terminal);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)openCrate);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, inventoryTrim);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)paintedTrim));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCable);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)invCableFramed, new Item.Properties().m_41491_(STORAGE_MOD_TAB)));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCableConnector);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCableConnectorFiltered);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)invProxy, new Item.Properties().m_41491_(STORAGE_MOD_TAB)));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)craftingTerminal);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invHopperBasic);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)levelEmitter);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCableConnectorFramed);
            itemRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{paintingKit, wirelessTerminal, advWirelessTerminal});
        }

        private static void registerItemForBlock(RegistryEvent.Register<Item> itemRegistryEvent, Block block) {
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(STORAGE_MOD_TAB)).setRegistryName(block.getRegistryName())));
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<BlockEntityType<?>> tileRegistryEvent) {
            connectorTile = BlockEntityType.Builder.m_155273_(TileEntityInventoryConnector::new, (Block[])new Block[]{connector}).m_58966_(null);
            connectorTile.setRegistryName("ts.inventory_connector.tile");
            terminalTile = BlockEntityType.Builder.m_155273_(TileEntityStorageTerminal::new, (Block[])new Block[]{terminal}).m_58966_(null);
            terminalTile.setRegistryName("ts.storage_terminal.tile");
            openCrateTile = BlockEntityType.Builder.m_155273_(TileEntityOpenCrate::new, (Block[])new Block[]{openCrate}).m_58966_(null);
            openCrateTile.setRegistryName("ts.open_crate.tile");
            paintedTile = BlockEntityType.Builder.m_155273_(TileEntityPainted::new, (Block[])new Block[]{paintedTrim, invCableFramed}).m_58966_(null);
            paintedTile.setRegistryName("ts.painted.tile");
            invCableConnectorTile = BlockEntityType.Builder.m_155273_(TileEntityInventoryCableConnector::new, (Block[])new Block[]{invCableConnector, invCableConnectorFramed}).m_58966_(null);
            invCableConnectorTile.setRegistryName("ts.inventory_cable_connector.tile");
            invCableConnectorFilteredTile = BlockEntityType.Builder.m_155273_(TileEntityInventoryCableConnectorFiltered::new, (Block[])new Block[]{invCableConnectorFiltered}).m_58966_(null);
            invCableConnectorFilteredTile.setRegistryName("ts.inventory_cable_connector_filtered.tile");
            invProxyTile = BlockEntityType.Builder.m_155273_(TileEntityInventoryProxy::new, (Block[])new Block[]{invProxy}).m_58966_(null);
            invProxyTile.setRegistryName("ts.inventory_proxy.tile");
            craftingTerminalTile = BlockEntityType.Builder.m_155273_(TileEntityCraftingTerminal::new, (Block[])new Block[]{craftingTerminal}).m_58966_(null);
            craftingTerminalTile.setRegistryName("ts.crafting_terminal.tile");
            invHopperBasicTile = BlockEntityType.Builder.m_155273_(TileEntityInventoryHopperBasic::new, (Block[])new Block[]{invHopperBasic}).m_58966_(null);
            invHopperBasicTile.setRegistryName("ts.inventoty_hopper_basic.tile");
            levelEmitterTile = BlockEntityType.Builder.m_155273_(TileEntityLevelEmitter::new, (Block[])new Block[]{levelEmitter}).m_58966_(null);
            levelEmitterTile.setRegistryName("ts.level_emitter.tile");
            tileRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new BlockEntityType[]{connectorTile, terminalTile, openCrateTile, paintedTile, invCableConnectorTile, invCableConnectorFilteredTile, invProxyTile, craftingTerminalTile, invHopperBasicTile, levelEmitterTile});
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<MenuType<?>> containerRegistryEvent) {
            storageTerminal = new MenuType(ContainerStorageTerminal::new);
            storageTerminal.setRegistryName("ts.storage_terminal.container");
            craftingTerminalCont = new MenuType(ContainerCraftingTerminal::new);
            craftingTerminalCont.setRegistryName("ts.crafting_terminal.container");
            filteredConatiner = new MenuType(ContainerFiltered::new);
            filteredConatiner.setRegistryName("ts.filtered.container");
            levelEmitterConatiner = new MenuType(ContainerLevelEmitter::new);
            levelEmitterConatiner.setRegistryName("ts.level_emitter.container");
            inventoryLink = new MenuType(ContainerInventoryLink::new);
            inventoryLink.setRegistryName("ts.inventory_link.container");
            containerRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])new MenuType[]{storageTerminal, craftingTerminalCont, filteredConatiner, levelEmitterConatiner, inventoryLink});
        }
    }
}

