/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.gui.ContainerInventoryLink;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorBase;
import com.tom.storagemod.util.IInventoryLink;
import com.tom.storagemod.util.RemoteConnections;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInventoryCableConnector
extends TileEntityInventoryCableConnectorBase
implements MenuProvider,
IInventoryLink {
    private static final String CHANNEL_TAG = "channel";
    private static final String REMOTE_TAG = "remote";
    private UUID channel = null;
    private int beaconLevel = -1;
    private boolean remote;

    public TileEntityInventoryCableConnector(BlockPos pos, BlockState state) {
        super(StorageMod.invCableConnectorTile, pos, state);
    }

    @Override
    public void updateServer() {
        super.updateServer();
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 18L) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction facing = (Direction)state.m_61143_((Property)BlockInventoryCableConnector.FACING);
            BlockPos pos = this.f_58858_.m_142300_(facing);
            BlockState st = this.f_58857_.m_8055_(pos);
            this.beaconLevel = st.m_60713_(Blocks.f_50273_) ? TileEntityInventoryCableConnector.calcBeaconLevel(this.f_58857_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) : -1;
        }
    }

    @Override
    protected LazyOptional<IItemHandler> getPointedAt(BlockPos pos, Direction facing) {
        if (this.beaconLevel >= 0) {
            RemoteConnections.Channel chn;
            if (this.channel != null && this.beaconLevel > 0 && (chn = RemoteConnections.get(this.f_58857_).getChannel(this.channel)) != null) {
                if (!this.remote) {
                    IItemHandler h = chn.findOthers((ServerLevel)this.f_58857_, this.f_58858_, this.beaconLevel);
                    return LazyOptional.of(() -> h);
                }
                chn.register((ServerLevel)this.f_58857_, this.f_58858_);
            }
            return null;
        }
        return super.getPointedAt(pos, facing);
    }

    public static int calcBeaconLevel(Level world, int x, int y, int z) {
        int i = 0;
        BlockEntity ent = world.m_7702_(new BlockPos(x, y, z));
        if (ent instanceof BeaconBlockEntity) {
            int k;
            BeaconBlockEntity b = (BeaconBlockEntity)ent;
            if (b.m_58702_().isEmpty()) {
                return 0;
            }
            int j = 1;
            while (j <= 4 && (k = y - j) >= world.m_141937_()) {
                boolean flag = true;
                block1: for (int l = x - j; l <= x + j && flag; ++l) {
                    for (int i1 = z - j; i1 <= z + j; ++i1) {
                        if (world.m_8055_(new BlockPos(l, k, i1)).m_204336_(BlockTags.f_13079_)) continue;
                        flag = false;
                        continue block1;
                    }
                }
                if (!flag) break;
                i = j++;
            }
        }
        return i;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory plInv, Player arg2) {
        return new ContainerInventoryLink(id, plInv, this);
    }

    public Component m_5446_() {
        return new TranslatableComponent("ts.inventory_connector");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.channel != null) {
            compound.m_128362_(CHANNEL_TAG, this.channel);
        }
        compound.m_128379_(REMOTE_TAG, this.remote);
    }

    @Override
    public void m_142466_(CompoundTag nbtIn) {
        super.m_142466_(nbtIn);
        this.channel = nbtIn.m_128441_(CHANNEL_TAG) ? nbtIn.m_128342_(CHANNEL_TAG) : null;
        this.remote = nbtIn.m_128471_(REMOTE_TAG);
    }

    @Override
    public LazyOptional<IItemHandler> getInventoryFrom(Level fromWorld, int fromLevel) {
        if (!this.remote || this.beaconLevel < Config.invLinkBeaconLvl) {
            return null;
        }
        if (this.beaconLevel >= Config.invLinkBeaconLvlDim || fromLevel >= Config.invLinkBeaconLvlDim) {
            return this.getCapability();
        }
        if (fromWorld.m_46472_().equals((Object)this.f_58857_.m_46472_())) {
            return this.getCapability();
        }
        return null;
    }

    public boolean stillValid(Player p_59619_) {
        RemoteConnections.Channel chn;
        if (this.channel != null && (chn = RemoteConnections.get(this.f_58857_).getChannel(this.channel)) != null && !chn.publicChannel && !chn.owner.equals(p_59619_.m_142081_())) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this || this.beaconLevel < 0) {
            return false;
        }
        return !(p_59619_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Override
    public UUID getChannel() {
        return this.channel;
    }

    public void setChannel(UUID channel) {
        RemoteConnections.get(this.f_58857_).invalidateCache(this.channel);
        this.channel = channel;
        this.m_6596_();
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
        this.m_6596_();
    }
}

