/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.client.gui.screen;

import com.codetaylor.mc.enercell.EnercellMod;
import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import com.codetaylor.mc.enercell.container.EnercellContainer;
import com.codetaylor.mc.enercell.init.ModNetwork;
import com.codetaylor.mc.enercell.network.ServerboundEnercellChargeModeMessage;
import com.codetaylor.mc.enercell.util.UtilFormat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EnercellScreen
extends AbstractContainerScreen<EnercellContainer> {
    private static final ResourceLocation TEXTURE = EnercellMod.id("textures/gui/enercell.png");
    private static final Function<String, String> SUFFIX_FORMAT = arg_0 -> EnercellScreen.lambda$static$0(" %sFE", arg_0);
    private ModeButton modeButton;

    public EnercellScreen(EnercellContainer container, Inventory inventory, Component component) {
        super((AbstractContainerMenu)container, inventory, component);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.modeButton = new ModeButton(this.f_97735_ + 75, this.f_97736_ + 31, ((EnercellContainer)this.f_97732_)::getChargeMode, () -> {
            ((EnercellContainer)this.f_97732_).cycleChargeMode();
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundEnercellChargeModeMessage(((EnercellContainer)this.f_97732_).getBlockPos(), ((EnercellContainer)this.f_97732_).getChargeMode()));
        });
        this.m_142416_((GuiEventListener)this.modeButton);
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(@Nonnull PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, offsetX, offsetY, 0, 0, this.f_97726_, this.f_97727_);
        int energy = ((EnercellContainer)this.f_97732_).getEnergy();
        if (energy == 0) {
            return;
        }
        float energyScalar = (float)energy / (float)((EnercellContainer)this.f_97732_).getEnergyCapacity();
        int height = 39;
        int v0 = Math.min(height - 1, Math.round((float)height * (1.0f - energyScalar)));
        this.m_93228_(poseStack, offsetX + 22, offsetY + 25 + v0, 176, v0, 42, height);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        this.renderEnergyTooltip(poseStack, mouseX, mouseY);
        if (this.modeButton.isShowingTooltip()) {
            this.modeButton.m_7428_(poseStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    private void renderEnergyTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        int offsetX = (this.f_96543_ - this.f_97726_) / 2;
        int offsetY = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseX < offsetX + 22 || mouseX > offsetX + 22 + 42 || mouseY < offsetY + 25 || mouseY > offsetY + 25 + 39) {
            return;
        }
        int energy = ((EnercellContainer)this.f_97732_).getEnergy();
        int energyCapacity = ((EnercellContainer)this.f_97732_).getEnergyCapacity();
        double clientAverageCharge = ((EnercellContainer)this.f_97732_).getChargeMode() == EnercellBlockEntity.ChargeMode.Drain ? -((EnercellContainer)this.f_97732_).getClientAverageCharge() : ((EnercellContainer)this.f_97732_).getClientAverageCharge();
        double clientAverageInput = ((EnercellContainer)this.f_97732_).getClientAverageInput();
        double clientAverageOutput = ((EnercellContainer)this.f_97732_).getClientAverageOutput();
        int total = (int)Math.floor(clientAverageInput - (clientAverageCharge + clientAverageOutput));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new TextComponent("Energy: %s / %s".formatted(UtilFormat.displayDouble(energy, SUFFIX_FORMAT), UtilFormat.displayDouble(energyCapacity, SUFFIX_FORMAT))));
        list.add(new TextComponent("  Charge: %s/s".formatted(UtilFormat.displayDouble(clientAverageCharge, SUFFIX_FORMAT))).m_130940_(ChatFormatting.GRAY));
        list.add(new TextComponent("  Input:  %s/s".formatted(UtilFormat.displayDouble(clientAverageInput, SUFFIX_FORMAT))).m_130940_(ChatFormatting.GRAY));
        list.add(new TextComponent("  Output: %s/s".formatted(UtilFormat.displayDouble(clientAverageOutput, SUFFIX_FORMAT))).m_130940_(ChatFormatting.GRAY));
        if (total > 0) {
            list.add(new TextComponent("  Total:  %s/s".formatted(UtilFormat.displayDouble(total, SUFFIX_FORMAT))).m_130940_(ChatFormatting.DARK_GREEN));
        } else if (total < 0) {
            list.add(new TextComponent("  Total:  -%s/s".formatted(UtilFormat.displayDouble(Math.abs(total), SUFFIX_FORMAT))).m_130940_(ChatFormatting.DARK_RED));
        } else {
            list.add(new TextComponent("  Total:  %s/s".formatted(UtilFormat.displayDouble(total, SUFFIX_FORMAT))).m_130940_(ChatFormatting.GRAY));
        }
        this.m_96597_(poseStack, list, mouseX, mouseY);
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return " %sFE".formatted(xva$0);
    }

    public static class ModeButton
    extends AbstractButton {
        private final Supplier<EnercellBlockEntity.ChargeMode> chargeModeSupplier;
        private final Runnable onPressAction;

        public ModeButton(int x, int y, Supplier<EnercellBlockEntity.ChargeMode> chargeModeSupplier, Runnable onPressAction) {
            super(x, y, 22, 22, TextComponent.f_131282_);
            this.chargeModeSupplier = chargeModeSupplier;
            this.onPressAction = onPressAction;
        }

        public void m_6303_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int u = 0;
            int v = 166;
            if (!this.f_93623_) {
                u += this.f_93618_ * 2;
            } else if (this.m_198029_()) {
                u += this.f_93618_ * 3;
            }
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
            this.renderIcon(poseStack);
        }

        private void renderIcon(PoseStack poseStack) {
            switch (this.chargeModeSupplier.get()) {
                case Charge: {
                    this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 88, 166, this.f_93618_, this.f_93619_);
                    break;
                }
                case Drain: {
                    this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 110, 166, this.f_93618_, this.f_93619_);
                }
            }
        }

        public boolean isShowingTooltip() {
            return this.f_93622_;
        }

        public void m_142291_(@Nonnull NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public void m_5691_() {
            this.onPressAction.run();
        }
    }
}

