/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.item;

import com.codetaylor.mc.enercell.init.ModConfigs;
import com.codetaylor.mc.enercell.util.UtilFormat;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnercellBlockItem
extends BlockItem {
    private static final Function<String, String> SUFFIX_FORMAT = arg_0 -> EnercellBlockItem.lambda$static$0(" %sFE", arg_0);

    public EnercellBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean m_142522_(@Nonnull ItemStack itemStack) {
        return true;
    }

    private static int getStoredEnergy(ItemStack itemStack) {
        CompoundTag tag;
        int energy = 0;
        if (itemStack.m_41720_() instanceof EnercellBlockItem && (tag = itemStack.m_41783_()) != null && tag.m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
            energy = blockEntityTag.m_128451_("EnergyStorage");
        }
        return energy;
    }

    private static void setStoredEnergy(ItemStack itemStack, int energy) {
        if (itemStack.m_41720_() instanceof EnercellBlockItem) {
            CompoundTag tag = itemStack.m_41784_();
            CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
            blockEntityTag.m_128405_("EnergyStorage", energy);
            tag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        }
    }

    public int m_142158_(@Nonnull ItemStack itemStack) {
        if (ModConfigs.ENERCELL == null) {
            return 0;
        }
        return Math.round((float)EnercellBlockItem.getStoredEnergy(itemStack) * 13.0f / (float)ModConfigs.ENERCELL.getEnergyCapacity());
    }

    public int m_142159_(@Nonnull ItemStack itemStack) {
        return 65535;
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> componentList, TooltipFlag advancedTooltipFlag) {
        if (itemStack.m_41720_() == this && ModConfigs.ENERCELL != null) {
            componentList.add((Component)new TextComponent("Energy: %s / %s".formatted(UtilFormat.displayDouble(EnercellBlockItem.getStoredEnergy(itemStack), SUFFIX_FORMAT), UtilFormat.displayDouble(ModConfigs.ENERCELL.getEnergyCapacity(), SUFFIX_FORMAT))).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        if (itemStack.m_41720_() == this) {
            return new CapabilityProvider(new EnercellBlockItemEnergyStorage(itemStack, ModConfigs.ENERCELL.getEnergyCapacity()));
        }
        return null;
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return " %sFE".formatted(xva$0);
    }

    public static class CapabilityProvider
    implements ICapabilityProvider {
        private final IEnergyStorage itemEnergyStorage;
        private final LazyOptional<IEnergyStorage> itemEnergyStorageLazyOptional;

        public CapabilityProvider(IEnergyStorage itemEnergyStorage) {
            this.itemEnergyStorage = itemEnergyStorage;
            this.itemEnergyStorageLazyOptional = LazyOptional.of(() -> this.itemEnergyStorage);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY) {
                return this.itemEnergyStorageLazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class EnercellBlockItemEnergyStorage
    implements IEnergyStorage {
        private final ItemStack itemStack;
        private final int capacity;

        public EnercellBlockItemEnergyStorage(ItemStack itemStack, int capacity) {
            this.itemStack = itemStack;
            this.capacity = capacity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyReceived = Math.min(this.capacity - energyStored, maxReceive);
            if (!simulate) {
                EnercellBlockItem.setStoredEnergy(this.itemStack, energyStored + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyExtracted = Math.min(energyStored, maxExtract);
            if (!simulate) {
                EnercellBlockItem.setStoredEnergy(this.itemStack, energyStored - energyExtracted);
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return EnercellBlockItem.getStoredEnergy(this.itemStack);
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

