/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.network;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEnercellRollingAverageUpdateMessage {
    public final BlockPos blockPos;
    public final double charge;
    public final double input;
    public final double output;

    public ClientboundEnercellRollingAverageUpdateMessage(BlockPos blockPos, double charge, double input, double output) {
        this.blockPos = blockPos;
        this.charge = charge;
        this.input = input;
        this.output = output;
    }

    public static void encode(ClientboundEnercellRollingAverageUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.writeDouble(message.charge);
        buffer.writeDouble(message.input);
        buffer.writeDouble(message.output);
    }

    public static ClientboundEnercellRollingAverageUpdateMessage decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        double charge = buffer.readDouble();
        double input = buffer.readDouble();
        double output = buffer.readDouble();
        return new ClientboundEnercellRollingAverageUpdateMessage(blockPos, charge, input, output);
    }

    public static void handle(ClientboundEnercellRollingAverageUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                return;
            }
            BlockEntity blockEntity = minecraft.f_91073_.m_7702_(message.blockPos);
            if (!(blockEntity instanceof EnercellBlockEntity)) {
                return;
            }
            EnercellBlockEntity enercellBlockEntity = (EnercellBlockEntity)blockEntity;
            enercellBlockEntity.setClientAverages(message.charge, message.input, message.output);
        });
        context.setPacketHandled(true);
    }
}

