/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.network;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundEnercellChargeModeMessage {
    public final BlockPos blockPos;
    public final EnercellBlockEntity.ChargeMode chargeMode;

    public ServerboundEnercellChargeModeMessage(BlockPos blockPos, EnercellBlockEntity.ChargeMode chargeMode) {
        this.blockPos = blockPos;
        this.chargeMode = chargeMode;
    }

    public static void encode(ServerboundEnercellChargeModeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.writeByte((int)message.chargeMode.getSerializationId());
    }

    public static ServerboundEnercellChargeModeMessage decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        EnercellBlockEntity.ChargeMode chargeMode = EnercellBlockEntity.ChargeMode.from(buffer.readByte());
        return new ServerboundEnercellChargeModeMessage(blockPos, chargeMode);
    }

    public static void handle(ServerboundEnercellChargeModeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            ServerLevel level = serverPlayer.m_183503_();
            BlockEntity blockEntity = level.m_7702_(message.blockPos);
            if (!(blockEntity instanceof EnercellBlockEntity)) {
                return;
            }
            EnercellBlockEntity enercellBlockEntity = (EnercellBlockEntity)blockEntity;
            enercellBlockEntity.setChargeMode(message.chargeMode);
        });
        context.setPacketHandled(true);
    }
}

