/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;

public final class UtilFormat {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public static String displayDouble(double d, Function<String, String> suffixFormat) {
        boolean negative;
        boolean bl = negative = d < 0.0;
        if (negative) {
            d = Math.abs(d);
        }
        if (d < 9.223372036854776E18) {
            d = Math.round(d + 1.0E-6);
        }
        int digits = d == 0.0 ? 0 : (int)(1.0 + Math.floor(Math.log10(Math.abs(d))));
        int exp = digits <= 4 ? 0 : 3 * ((digits - 1) / 3);
        String s = FORMAT.format(d);
        int fullLength = s.length();
        s = s.substring(0, Math.min(5, fullLength));
        if (fullLength <= 3) {
            return UtilFormat.formatSuffix((String)(negative ? "-" + s : s), "", suffixFormat);
        }
        s = fullLength <= 6 ? UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "k", suffixFormat) : (fullLength <= 9 ? UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "M", suffixFormat) : (fullLength <= 12 ? UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "B", suffixFormat) : (fullLength <= 15 ? UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "T", suffixFormat) : (fullLength <= 18 ? UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "Q", suffixFormat) : UtilFormat.formatSuffix(UtilFormat.formatNumber(s, fullLength), "e" + exp, suffixFormat)))));
        return negative ? "-" + s : s;
    }

    private static String formatSuffix(String numberString, String suffix, Function<String, String> suffixFormat) {
        return numberString + suffixFormat.apply(suffix);
    }

    private static String formatNumber(String s, int fullLength) {
        int i;
        int endIndex = (fullLength - 1) % 3 + 1;
        for (i = endIndex + 2; i >= endIndex && s.charAt(i - 1) == '0'; --i) {
        }
        if (endIndex < i) {
            return s.substring(0, endIndex) + "." + s.substring(endIndex, Math.min(fullLength, endIndex + 2));
        }
        return s.substring(0, endIndex);
    }

    private UtilFormat() {
    }

    static {
        FORMAT.setMaximumFractionDigits(3);
        FORMAT.setRoundingMode(RoundingMode.CEILING);
    }
}

