/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public class RecipeWrapper {
    public Set<SingleRecipe> recipes = new HashSet<SingleRecipe>();

    public boolean addRecipe(SingleRecipe recipe) {
        return this.recipes.add(recipe);
    }

    public boolean addRecipe(List<Ingredient> recipe, ItemStack outputStack, Recipe iRecipe) {
        return this.recipes.add(new SingleRecipe(recipe, outputStack, iRecipe));
    }

    public SingleRecipe canCraftFromInventory(Map<Item, Integer> inventory) {
        for (SingleRecipe recipe : this.recipes) {
            List<ItemStack> itemsNeeded = recipe.canCraftFromInventory(inventory);
            if (itemsNeeded == null) continue;
            return recipe;
        }
        return null;
    }

    public SingleRecipe canCraftPotionFromInventory(Map<Item, Integer> inventory, Level world, BlockPos pos) {
        for (SingleRecipe recipe : this.recipes) {
            List<ItemStack> itemsNeeded = recipe.canCraftPotionFromInventory(inventory, world, pos);
            if (itemsNeeded == null) continue;
            return recipe;
        }
        return null;
    }

    public static class SingleRecipe {
        public List<Ingredient> recipe;
        public ItemStack outputStack;
        public Recipe iRecipe;

        public SingleRecipe(List<Ingredient> ingredients, ItemStack outputStack, Recipe iRecipe) {
            this.recipe = ingredients;
            this.outputStack = outputStack;
            this.iRecipe = iRecipe;
        }

        public List<ItemStack> canCraftPotionFromInventory(Map<Item, Integer> inventory, Level world, BlockPos pos) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>(inventory);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Ingredient i : this.recipe) {
                boolean foundStack = false;
                for (ItemStack stack : i.m_43908_()) {
                    if (stack.m_41720_() == Items.f_42589_) {
                        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
                        if (potion == Potions.f_43599_ || WixieCauldronTile.findNeededPotion(PotionUtils.m_43579_((ItemStack)stack), 300, world, pos) != null) {
                            foundStack = true;
                            continue;
                        }
                        return null;
                    }
                    if (!inventory.containsKey(stack.m_41720_()) || (Integer)map.get(stack.m_41720_()) <= 0) continue;
                    map.put(stack.m_41720_(), (Integer)map.get(stack.m_41720_()) - 1);
                    foundStack = true;
                    items.add(stack.m_41777_());
                    break;
                }
                if (foundStack) continue;
                return null;
            }
            return items;
        }

        public List<ItemStack> canCraftFromInventory(Map<Item, Integer> inventory) {
            HashMap<Item, Integer> map = new HashMap<Item, Integer>(inventory);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (Ingredient i : this.recipe) {
                boolean foundStack = false;
                for (ItemStack stack : i.m_43908_()) {
                    if (!inventory.containsKey(stack.m_41720_()) || (Integer)map.get(stack.m_41720_()) <= 0) continue;
                    map.put(stack.m_41720_(), (Integer)map.get(stack.m_41720_()) - 1);
                    foundStack = true;
                    items.add(stack.m_41777_());
                    break;
                }
                if (foundStack) continue;
                return null;
            }
            return items;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleRecipe recipe1 = (SingleRecipe)o;
            return Objects.equals(this.recipe, recipe1.recipe) && Objects.equals(this.outputStack, recipe1.outputStack);
        }

        public int hashCode() {
            return Objects.hash(this.recipe, this.outputStack);
        }
    }
}

