/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity.familiar;

import com.hollingsworth.arsnouveau.client.renderer.entity.familiar.GenericFamiliarRenderer;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarStarbuncle;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.model.provider.data.EntityModelData;

public class FamiliarCarbyRenderer<T extends FamiliarStarbuncle>
extends GenericFamiliarRenderer<T> {
    public FamiliarCarbyRenderer(EntityRendererProvider.Context manager) {
        super(manager, new FamiliarCarbyModel());
    }

    public ResourceLocation getColor(FamiliarStarbuncle e) {
        String color = e.getColor().toLowerCase();
        if (color.isEmpty()) {
            color = "orange";
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    @Override
    public ResourceLocation getTextureLocation(T entity) {
        return this.getColor((FamiliarStarbuncle)entity);
    }

    public static class FamiliarCarbyModel<T extends FamiliarStarbuncle>
    extends AnimatedGeoModel<T> {
        private final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
        private final ResourceLocation TAMED_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");

        @Override
        public void setLivingAnimations(T entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
            super.setLivingAnimations(entity, uniqueID, customPredicate);
            IBone head = this.getAnimationProcessor().getBone("head");
            EntityModelData extraData = customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }

        @Override
        public ResourceLocation getModelLocation(FamiliarStarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "geo/carbuncle.geo.json");
        }

        @Override
        public ResourceLocation getTextureLocation(FamiliarStarbuncle carbuncle) {
            return this.WILD_TEXTURE;
        }

        @Override
        public ResourceLocation getAnimationFileLocation(FamiliarStarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "animations/starbuncle_animations.json");
        }
    }
}

