/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;

public class BasicSpellTurret
extends TickableModBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static HashMap<AbstractCastMethod, ITurretBehavior> TURRET_BEHAVIOR_MAP = new HashMap();
    static final VoxelShape shape;

    public BasicSpellTurret(BlockBehaviour.Properties properties, String registry) {
        super(properties, registry);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public BasicSpellTurret(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public BasicSpellTurret() {
        this(BasicSpellTurret.defaultProperties().m_60955_(), "basic_spell_turret");
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        this.shootSpell(worldIn, pos);
    }

    public void shootSpell(ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BasicSpellTurretTile)) {
            return;
        }
        BasicSpellTurretTile tile = (BasicSpellTurretTile)blockEntity;
        ISpellCaster caster = tile.getSpellCaster();
        if (caster.getSpell().isEmpty()) {
            return;
        }
        int manaCost = tile.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceNearbyWithParticles(pos, (Level)world, 10, manaCost) == null) {
            return;
        }
        Networking.sendToNearby((Level)world, pos, (Object)new PacketOneShotAnimation(pos));
        Position iposition = BasicSpellTurret.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos));
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer(world);
        fakePlayer.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(caster, (LivingEntity)fakePlayer).withCastingTile(world.m_7702_(pos)).withType(SpellContext.CasterType.TURRET));
        if (resolver.castType != null && TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            TURRET_BEHAVIOR_MAP.get(resolver.castType).onCast(resolver, tile, world, pos, fakePlayer, iposition, direction);
            caster.playSound(pos, (Level)world, null, caster.getCurrentSound(), SoundSource.BLOCKS);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean neighborSignal = worldIn.m_46753_(pos) || worldIn.m_46753_(pos.m_7494_());
        boolean isTriggered = (Boolean)state.m_61143_((Property)TRIGGERED);
        if (neighborSignal && !isTriggered) {
            worldIn.m_186460_(pos, (Block)this, 4);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
        } else if (!neighborSignal && isTriggered) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public static Position getDispensePosition(BlockSource coords) {
        Direction direction = (Direction)coords.m_6414_().m_61143_((Property)FACING);
        double d0 = coords.m_7096_() + 0.5 * (double)direction.m_122429_();
        double d1 = coords.m_7098_() + 0.5 * (double)direction.m_122430_();
        double d2 = coords.m_7094_() + 0.5 * (double)direction.m_122431_();
        return new PositionImpl(d0, d1, d2);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(handIn);
            if (!(stack.m_41720_() instanceof SpellParchment) || worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Spell spell = CasterUtil.getCaster(stack).getSpell();
            if (spell.isEmpty()) {
                return InteractionResult.SUCCESS;
            }
            if (!TURRET_BEHAVIOR_MAP.containsKey(spell.getCastMethod())) {
                PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.alert.turret_type"));
                return InteractionResult.SUCCESS;
            }
            BasicSpellTurretTile tile = (BasicSpellTurretTile)worldIn.m_7702_(pos);
            tile.spellCaster.copyFromCaster(CasterUtil.getCaster(stack));
            tile.m_6596_();
            PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.alert.spell_set"));
            worldIn.m_7260_(pos, state, state, 2);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TRIGGERED});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BasicSpellTurretTile(pos, state);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    static {
        TURRET_BEHAVIOR_MAP.put(MethodProjectile.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, BasicSpellTurretTile tile, ServerLevel world, BlockPos pos, FakePlayer fakePlayer, Position iposition, Direction direction) {
                EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
                spell.m_5602_((Entity)fakePlayer);
                spell.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
                spell.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), 0.5f, 0.0f);
                world.m_7967_((Entity)spell);
            }
        });
        TURRET_BEHAVIOR_MAP.put(MethodTouch.INSTANCE, new ITurretBehavior(){

            @Override
            public void onCast(SpellResolver resolver, BasicSpellTurretTile tile, ServerLevel serverLevel, BlockPos pos, FakePlayer fakePlayer, Position dispensePosition, Direction direction) {
                BlockPos touchPos = new BlockPos(dispensePosition.m_7096_(), dispensePosition.m_7098_(), dispensePosition.m_7094_());
                if (direction == Direction.WEST || direction == Direction.NORTH) {
                    touchPos = touchPos.m_142300_(direction);
                }
                if (direction == Direction.DOWN) {
                    touchPos = touchPos.m_7495_();
                }
                resolver.onCastOnBlock(new BlockHitResult(new Vec3((double)touchPos.m_123341_(), (double)touchPos.m_123342_(), (double)touchPos.m_123343_()), direction.m_122424_(), new BlockPos(touchPos.m_123341_(), touchPos.m_123342_(), touchPos.m_123343_()), false));
            }
        });
        shape = Block.m_49796_((double)4.6, (double)4.6, (double)4.6, (double)11.6, (double)11.6, (double)11.6);
    }
}

