/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;

public class PotionMelderTile
extends ModdedTile
implements IAnimatable,
ITickable {
    int timeMixing;
    boolean isMixing;
    boolean hasMana;
    AnimationFactory manager = new AnimationFactory(this);

    public PotionMelderTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.POTION_MELDER_TYPE, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && !this.hasMana && this.f_58857_.m_46467_() % 20L == 0L && SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 5, 100) != null) {
            this.hasMana = true;
            this.updateBlock();
        }
        if (!this.hasMana) {
            return;
        }
        PotionJarTile tile1 = null;
        PotionJarTile tile2 = null;
        for (Direction d : Direction.values()) {
            if (d == Direction.UP || d == Direction.DOWN) continue;
            if (tile1 != null && tile2 != null) break;
            BlockEntity tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(d));
            if (!(tileEntity instanceof PotionJarTile) || ((PotionJarTile)tileEntity).getAmount() <= 0) continue;
            if (tile1 == null) {
                tile1 = (PotionJarTile)tileEntity;
                continue;
            }
            tile2 = (PotionJarTile)tileEntity;
        }
        if (tile1 == null || tile2 == null || tile1.getAmount() < 300 || tile2.getAmount() < 300) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        PotionJarTile combJar = null;
        if (this.f_58857_.m_7702_(this.f_58858_.m_7495_()) instanceof PotionJarTile) {
            combJar = (PotionJarTile)this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        if (combJar == null) {
            this.isMixing = false;
            this.timeMixing = 0;
            this.m_6596_();
            return;
        }
        List<MobEffectInstance> combined = this.getCombinedResult(tile1, tile2);
        if (!(combJar.isMixEqual(combined) && combJar.getMaxFill() - combJar.getCurrentFill() >= 100 || combJar.getAmount() == 0)) {
            this.isMixing = false;
            this.timeMixing = 0;
            this.m_6596_();
            return;
        }
        this.isMixing = true;
        ++this.timeMixing;
        ParticleColor color1 = ParticleColor.fromInt(tile1.getColor());
        ParticleColor color2 = ParticleColor.fromInt(tile2.getColor());
        if (this.f_58857_.f_46443_) {
            if (this.timeMixing >= 80 && combJar.getPotion() != Potions.f_43598_) {
                for (int i = 0; i < 3; ++i) {
                    double d0 = (double)this.f_58858_.m_123341_() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    double d1 = (double)(this.f_58858_.m_123342_() + 1) + ParticleUtil.inRange(-0.1, 0.4);
                    double d2 = (double)this.f_58858_.m_123343_() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    this.f_58857_.m_7106_(GlowParticleData.createData(ParticleColor.fromInt(combJar.getColor())), d0, d1, d2, 0.0, (double)0.01f, 0.0);
                }
            }
            int offset = 30;
            if (this.timeMixing >= 60) {
                this.f_58857_.m_7106_(GlowParticleData.createData(color1), (double)this.f_58858_.m_123341_() + 0.5 - Math.sin((double)ClientInfo.ticksInGame / 8.0) / 4.0, (double)this.f_58858_.m_123342_() + 0.75 - Math.pow(Math.sin((double)ClientInfo.ticksInGame / 32.0), 2.0) / 2.0, (double)this.f_58858_.m_123343_() + 0.5 - Math.cos((double)ClientInfo.ticksInGame / 8.0) / 4.0, 0.0, 0.0, 0.0);
                this.f_58857_.m_7106_(GlowParticleData.createData(color2), (double)this.f_58858_.m_123341_() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.f_58858_.m_123342_() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.f_58858_.m_123343_() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
            }
            if (this.timeMixing >= 80) {
                offset = 50;
                this.f_58857_.m_7106_(GlowParticleData.createData(color1), (double)this.f_58858_.m_123341_() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.f_58858_.m_123342_() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.f_58858_.m_123343_() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
                offset = 70;
                this.f_58857_.m_7106_(GlowParticleData.createData(color2), (double)this.f_58858_.m_123341_() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.f_58858_.m_123342_() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.f_58858_.m_123343_() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
            }
            if (this.timeMixing >= 120) {
                this.timeMixing = 0;
            }
            return;
        }
        if (this.timeMixing % 20 == 0 && this.timeMixing > 0 && this.timeMixing <= 60) {
            EntityFlyingItem item = new EntityFlyingItem(this.f_58857_, tile1.m_58899_().m_7494_(), this.f_58858_, Math.round(255.0f * color1.getRed()), Math.round(255.0f * color1.getGreen()), Math.round(255.0f * color1.getBlue())).withNoTouch();
            item.setDistanceAdjust(2.0f);
            this.f_58857_.m_7967_((Entity)item);
            EntityFlyingItem item2 = new EntityFlyingItem(this.f_58857_, tile2.m_58899_().m_7494_(), this.f_58858_, Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
            item2.setDistanceAdjust(2.0f);
            this.f_58857_.m_7967_((Entity)item2);
            this.m_6596_();
        }
        if (!this.f_58857_.f_46443_ && this.timeMixing >= 120) {
            ++this.timeMixing;
            if (this.timeMixing >= 120) {
                this.timeMixing = 0;
            }
            Potion jar1Potion = tile1.getPotion();
            if (combJar.getAmount() == 0) {
                combJar.setPotion(jar1Potion, combined);
                combJar.setFill(100);
                tile1.addAmount(-300);
                tile2.addAmount(-300);
                this.hasMana = false;
                this.updateBlock();
            } else if (combJar.isMixEqual(combined) && combJar.getMaxFill() - combJar.getCurrentFill() >= 100) {
                combJar.addAmount(100);
                tile1.addAmount(-300);
                tile2.addAmount(-300);
                this.hasMana = false;
                this.updateBlock();
            }
        }
    }

    public List<MobEffectInstance> getCombinedCustomResult(PotionJarTile jar1, PotionJarTile jar2) {
        HashSet<MobEffectInstance> set = new HashSet<MobEffectInstance>();
        set.addAll(jar1.getCustomEffects());
        set.addAll(jar2.getCustomEffects());
        return new ArrayList<MobEffectInstance>(set);
    }

    public List<MobEffectInstance> getCombinedResult(PotionJarTile jar1, PotionJarTile jar2) {
        HashSet<MobEffectInstance> set = new HashSet<MobEffectInstance>();
        set.addAll(jar1.getFullEffects());
        set.addAll(jar2.getFullEffects());
        return new ArrayList<MobEffectInstance>(set);
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("spin", true));
        return this.isMixing ? PlayState.CONTINUE : PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController<PotionMelderTile>(this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.manager;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.timeMixing = nbt.m_128451_("mixing");
        this.isMixing = nbt.m_128471_("isMixing");
        this.hasMana = nbt.m_128471_("hasMana");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("mixing", this.timeMixing);
        compound.m_128379_("isMixing", this.isMixing);
        compound.m_128379_("hasMana", this.hasMana);
    }
}

