/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;

public class SourcelinkTile
extends AbstractSourceMachine
implements IAnimatable,
ITickable {
    int progress;
    public boolean isDisabled = false;
    public boolean registered = false;
    AnimationFactory factory = new AnimationFactory(this);

    public SourcelinkTile(BlockEntityType<?> sourceLinkTile, BlockPos pos, BlockState state) {
        super(sourceLinkTile, pos, state);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public int getMaxSource() {
        return 1000;
    }

    @Override
    public void tick() {
        BlockPos jarPos;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 120L == 0L && this.usesEventQueue()) {
            SourcelinkEventQueue.addPosition(this.f_58857_, this.f_58858_);
            this.registered = true;
        }
        if (this.f_58857_.m_46467_() % 100L == 0L && this.getSource() > 0 && (jarPos = SourceUtil.canGiveSourceClosest(this.f_58858_, this.f_58857_, 5)) != null) {
            this.transferSource(this, (ISourceTile)this.f_58857_.m_7702_(jarPos));
            ParticleUtil.spawnFollowProjectile(this.f_58857_, this.f_58858_, jarPos);
        }
    }

    public List<ArcanePedestalTile> getSurroundingPedestals() {
        ArrayList<ArcanePedestalTile> inventories = new ArrayList<ArcanePedestalTile>();
        for (BlockPos p : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7495_().m_142126_().m_142127_(), (BlockPos)this.m_58899_().m_7494_().m_142125_().m_142128_())) {
            if (!(this.f_58857_.m_7702_(p) instanceof ArcanePedestalTile)) continue;
            inventories.add((ArcanePedestalTile)this.f_58857_.m_7702_(p));
        }
        return inventories;
    }

    public void getManaEvent(BlockPos sourcePos, int total) {
        this.addSource(total);
        ParticleUtil.spawnFollowProjectile(this.f_58857_, sourcePos, this.f_58858_);
    }

    public boolean eventInRange(BlockPos sourcePos, @Nullable Event event) {
        return BlockUtil.distanceFrom(this.f_58858_, sourcePos) <= 15.0;
    }

    public boolean usesEventQueue() {
        return false;
    }

    public void doRandomAction() {
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController<SourcelinkTile>(this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        this.isDisabled = tag.m_128471_("disabled");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("disabled", this.isDisabled);
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        if (this.isDisabled) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("rotation", true));
        return PlayState.CONTINUE;
    }
}

