/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;

public class VolcanicSourcelinkTile
extends SourcelinkTile
implements IAnimatable {
    public VolcanicSourcelinkTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.VOLCANIC_TILE, pos, state);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && this.canAcceptSource()) {
            for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(1.0))) {
                int source = this.getSourceValue(itemEntity.m_32055_());
                if (source <= 0) continue;
                this.addSource(source);
                ItemStack containerItem = itemEntity.m_32055_().getContainerItem();
                itemEntity.m_32055_().m_41774_(1);
                if (!containerItem.m_41619_()) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), containerItem));
                }
                Networking.sendToNearby(this.f_58857_, this.m_58899_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, itemEntity.m_142538_(), new ParticleColor.IntWrapper(255, 0, 0), new int[0]));
                return;
            }
            for (ArcanePedestalTile arcanePedestalTile : this.getSurroundingPedestals()) {
                int sourceValue = this.getSourceValue(arcanePedestalTile.m_8020_(0));
                if (sourceValue <= 0) continue;
                this.addSource(sourceValue);
                ItemStack containerItem = arcanePedestalTile.m_8020_(0).getContainerItem();
                arcanePedestalTile.m_7407_(0, 1);
                arcanePedestalTile.m_6836_(0, containerItem);
                Networking.sendToNearby(this.f_58857_, this.m_58899_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, arcanePedestalTile.m_58899_().m_7494_(), new ParticleColor.IntWrapper(255, 0, 0), new int[0]));
            }
        }
    }

    public int getSourceValue(ItemStack i) {
        int source = 0;
        int progress = 0;
        int burnTime = ForgeHooks.getBurnTime((ItemStack)i, null);
        if (burnTime > 0) {
            source = burnTime / 12;
            progress = 1;
        }
        if (i.m_41720_() == BlockRegistry.BLAZING_LOG.m_5456_()) {
            source += 100;
            progress += 5;
        } else if (i.m_204117_(ItemTagProvider.ARCHWOOD_LOG_TAG)) {
            source += 50;
            progress += 3;
        }
        if (i.m_41720_() == ItemsRegistry.FIRE_ESSENCE) {
            source = 2000;
        }
        this.progress += progress;
        return source;
    }

    @Override
    public void doRandomAction() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        AtomicBoolean set = new AtomicBoolean(false);
        BlockPos.m_121985_((BlockPos)this.f_58858_, (int)1, (int)0, (int)1).forEach(p -> {
            if (!set.get() && this.f_58857_.m_8055_(p).m_60795_() && (this.f_58857_.m_6425_(p.m_7495_()).m_76152_() == Fluids.f_76195_ || this.f_58857_.m_6425_(p.m_7495_()).m_76152_() == Fluids.f_76194_)) {
                this.f_58857_.m_46597_(p, BlockRegistry.LAVA_LILY.getState(this.f_58857_, (BlockPos)p));
                set.set(true);
            }
        });
        BlockPos magmaPos = this.getBlockInArea(Blocks.f_50450_, 1);
        if (magmaPos != null && this.progress >= 200) {
            this.f_58857_.m_46597_(magmaPos, Blocks.f_49991_.m_49966_());
            this.progress -= 200;
            return;
        }
        BlockPos stonePos = this.getBlockInArea(Blocks.f_50069_, 1);
        if (stonePos != null && this.progress >= 150) {
            this.f_58857_.m_46597_(stonePos, Blocks.f_50450_.m_49966_());
            this.progress -= 150;
            return;
        }
        stonePos = this.getTagInArea((TagKey<Block>)Tags.Blocks.STONE, 1);
        if (stonePos != null && this.progress >= 150) {
            this.f_58857_.m_46597_(stonePos, Blocks.f_50450_.m_49966_());
            this.progress -= 150;
            return;
        }
    }

    public BlockPos getTagInArea(TagKey<Block> block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(range, -1, range), (BlockPos)this.f_58858_.m_142082_(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.m_7949_();
            if (posFound.get() == null && this.f_58857_.m_8055_(blockPos).m_204336_(block)) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.m_121990_((BlockPos)this.f_58858_.m_142082_(range, -1, range), (BlockPos)this.f_58858_.m_142082_(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.m_7949_();
            if (posFound.get() == null && this.f_58857_.m_8055_(blockPos).m_60734_() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    @Override
    public int getMaxSource() {
        return 5000;
    }
}

