/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.RecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.ShapedHelper;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class WixieCauldronTile
extends SummoningTile
implements ITooltipProvider {
    public List<BlockPos> inventories;
    public ItemStack craftingItem;
    public int entityID;
    public boolean hasSource;
    private boolean isOff;
    public boolean isCraftingPotion;
    public boolean needsPotionStorage;
    RecipeWrapper recipeWrapper;
    public CraftingProgress craftManager = new CraftingProgress();

    public WixieCauldronTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.WIXIE_CAULDRON_TYPE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasSource && this.f_58857_.m_46467_() % 5L == 0L && SourceUtil.takeSourceNearbyWithParticles(this.f_58858_, this.f_58857_, 6, 50) != null) {
            this.hasSource = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(true)));
        }
        if (!this.hasSource) {
            return;
        }
        if (this.recipeWrapper == null && this.craftingItem != null) {
            this.setRecipes(null, this.craftingItem);
        }
        if (this.f_58857_.m_46467_() % 100L == 0L) {
            this.updateInventories();
        }
    }

    public boolean hasWixie() {
        return !this.converted || this.f_58857_.m_6815_(this.entityID) != null;
    }

    public boolean isCraftingDone() {
        return this.craftManager.isDone();
    }

    public boolean needsPotion() {
        return this.craftManager.isPotionCrafting && !this.craftManager.hasObtainedPotion();
    }

    public Potion getNeededPotion() {
        return this.craftManager.getPotionNeeded();
    }

    public void givePotion() {
        this.craftManager.setHasObtainedPotion(true);
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public boolean giveItem(ItemStack stack) {
        boolean res = this.craftManager.giveItem(stack.m_41720_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        return res;
    }

    public void attemptFinish() {
        if (this.craftManager.isDone()) {
            if (!this.isCraftingPotion) {
                if (!this.craftManager.outputStack.m_41619_()) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_(), this.craftManager.outputStack.m_41777_()));
                    this.hasSource = false;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false)));
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12049_, SoundSource.BLOCKS, 0.15f, 0.6f);
                }
                for (ItemStack i : this.craftManager.remainingItems) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_(), i.m_41777_()));
                }
                this.craftManager = new CraftingProgress();
                this.setNewCraft();
            } else {
                if (this.craftManager.potionOut == null) {
                    this.setNewCraft();
                    return;
                }
                BlockPos jarPos = this.findPotionStorage(this.craftManager.potionOut);
                if (jarPos == null) {
                    if (!this.needsPotionStorage) {
                        this.needsPotionStorage = true;
                        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
                    }
                    return;
                }
                if (this.f_58857_.m_7702_(jarPos) instanceof PotionJarTile) {
                    this.needsPotionStorage = false;
                    ((PotionJarTile)this.f_58857_.m_7702_(jarPos)).addAmount(this.craftManager.potionOut, 300);
                    int color = ((PotionJarTile)this.f_58857_.m_7702_(jarPos)).getColor();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    int a = color >> 24 & 0xFF;
                    EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(this.f_58857_, this.f_58858_, jarPos, r, g, b);
                    this.f_58857_.m_7967_((Entity)aoeProjectile);
                    this.hasSource = false;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false)));
                    this.craftManager = new CraftingProgress();
                    this.setNewCraft();
                }
            }
        }
    }

    public void setNewCraft() {
        if (this.recipeWrapper == null) {
            return;
        }
        Map<Item, Integer> count = this.getInventoryCount();
        if (this.isCraftingPotion && this.recipeWrapper.recipes.size() > 0) {
            RecipeWrapper.SingleRecipe recipe = this.recipeWrapper.canCraftPotionFromInventory(count, this.f_58857_, this.f_58858_);
            if (recipe == null) {
                return;
            }
            if (!(recipe.recipe.get(0) instanceof PotionIngredient)) {
                this.isCraftingPotion = false;
                return;
            }
            PotionIngredient potionIngred = (PotionIngredient)recipe.recipe.get(0);
            Ingredient itemIngred = recipe.recipe.get(1);
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>(Arrays.asList(itemIngred.m_43908_()));
            this.craftManager = new CraftingProgress(PotionUtils.m_43579_((ItemStack)potionIngred.getStack()), needed, PotionUtils.m_43579_((ItemStack)recipe.outputStack));
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        } else {
            RecipeWrapper.SingleRecipe recipe = this.recipeWrapper.canCraftFromInventory(count);
            if (recipe != null) {
                this.craftManager = new CraftingProgress(recipe.outputStack.m_41777_(), recipe.canCraftFromInventory(count), recipe.iRecipe);
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
            }
        }
    }

    public void setRecipes(Player playerEntity, ItemStack stack) {
        RecipeWrapper recipes = new RecipeWrapper();
        if (stack.m_41720_() == Items.f_42589_) {
            for (BrewingRecipe r : ArsNouveauAPI.getInstance().getAllPotionRecipes()) {
                if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)r.getOutput())) continue;
                this.isCraftingPotion = true;
                ArrayList<Ingredient> list = new ArrayList<Ingredient>();
                list.add(new PotionIngredient(r.getInput().m_43908_()[0]));
                list.add(r.getIngredient());
                recipes.addRecipe(list, r.getOutput(), null);
            }
        } else {
            for (Recipe r : this.f_58857_.m_142572_().m_129894_().m_44051_()) {
                if (r.m_8043_() == null || r.m_8043_().m_41720_() != stack.m_41720_()) continue;
                if (r instanceof ShapedRecipe) {
                    ShapedHelper helper = new ShapedHelper((ShapedRecipe)r);
                    for (List<Ingredient> iList : helper.getPossibleRecipes()) {
                        recipes.addRecipe(iList, r.m_8043_(), r);
                    }
                }
                if (!(r instanceof ShapelessRecipe)) continue;
                recipes.addRecipe((List<Ingredient>)r.m_7527_(), r.m_8043_(), r);
            }
            if (!recipes.recipes.isEmpty()) {
                this.isCraftingPotion = false;
            }
        }
        if (!recipes.recipes.isEmpty()) {
            this.recipeWrapper = recipes;
            this.craftingItem = stack.m_41777_();
        }
        if ((recipes.recipes.isEmpty() || this.recipeWrapper == null || this.recipeWrapper.recipes.isEmpty()) && playerEntity != null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.wixie.no_recipe"));
        } else if (playerEntity != null) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.wixie.recipe_set"));
        }
        this.m_6596_();
    }

    public void updateInventories() {
        this.inventories = new ArrayList<BlockPos>();
        for (BlockPos bPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_142390_(6).m_142385_(6).m_6625_(2), (BlockPos)this.f_58858_.m_142383_(6).m_142386_(6).m_6630_(2))) {
            if (!(this.f_58857_.m_7702_(bPos) instanceof Container)) continue;
            this.inventories.add(bPos.m_7949_());
        }
    }

    @Nullable
    public BlockPos findPotionStorage(Potion passedPot) {
        AtomicReference foundPod = new AtomicReference();
        AtomicBoolean foundOptimal = new AtomicBoolean(false);
        BlockPos.m_121985_((BlockPos)this.f_58858_.m_6625_(2), (int)4, (int)3, (int)4).forEach(bPos -> {
            PotionJarTile tile;
            if (!foundOptimal.get() && this.f_58857_.m_7702_(bPos) instanceof PotionJarTile && ((tile = (PotionJarTile)this.f_58857_.m_7702_(bPos)).canAcceptNewPotion() || tile.isMixEqual(passedPot)) && tile.getMaxFill() - tile.getCurrentFill() >= 300) {
                if (tile.isMixEqual(passedPot) && tile.getAmount() >= 0) {
                    foundOptimal.set(true);
                    foundPod.set(bPos.m_7949_());
                }
                if (foundPod.get() == null) {
                    foundPod.set(bPos.m_7949_());
                }
            }
        });
        return (BlockPos)foundPod.get();
    }

    @Nullable
    public static BlockPos findNeededPotion(Potion passedPot, int amount, Level level, BlockPos worldPosition) {
        AtomicReference foundPod = new AtomicReference();
        BlockPos.m_121985_((BlockPos)worldPosition.m_6625_(2), (int)4, (int)3, (int)4).forEach(bPos -> {
            PotionJarTile tile;
            if (foundPod.get() == null && level.m_7702_(bPos) instanceof PotionJarTile && (tile = (PotionJarTile)level.m_7702_(bPos)).getCurrentFill() >= amount && tile.isMixEqual(passedPot)) {
                foundPod.set(bPos.m_7949_());
            }
        });
        return (BlockPos)foundPod.get();
    }

    @Nullable
    public BlockPos findNeededPotion(Potion passedPot, int amount) {
        return WixieCauldronTile.findNeededPotion(passedPot, amount, this.f_58857_, this.f_58858_);
    }

    public void spawnFlyingItem(BlockPos from, ItemStack stack) {
        EntityFlyingItem flyingItem = new EntityFlyingItem(this.f_58857_, from.m_7494_(), this.f_58858_);
        flyingItem.m_20088_().m_135381_(EntityFlyingItem.HELD_ITEM, (Object)stack.m_41777_());
        this.f_58857_.m_7967_((Entity)flyingItem);
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.f_58857_.f_46443_) {
            this.converted = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityWixie wixie = new EntityWixie(this.f_58857_, true, this.f_58858_);
            wixie.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)wixie);
            ParticleUtil.spawnPoof((ServerLevel)this.f_58857_, this.f_58858_.m_7494_());
            this.entityID = wixie.m_142049_();
            this.tickCounter = 0;
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.f_58857_.f_46443_) {
            Random r = this.f_58857_.f_46441_;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.f_58857_, this.f_58858_.m_142082_(r.nextInt(max - min) + min, 3, r.nextInt(max - min) + min), this.f_58858_, r.nextInt(255), r.nextInt(255), r.nextInt(255));
            this.f_58857_.m_7967_((Entity)proj1);
        }
    }

    private Map<Item, Integer> getInventoryCount() {
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        HashMap<Item, Integer> itemsAvailable = new HashMap<Item, Integer>();
        if (this.inventories == null) {
            return itemsAvailable;
        }
        for (BlockPos p : this.inventories) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(p);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Container inventory = (Container)this.f_58857_.m_7702_(p);
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack stack = inventory.m_8020_(i);
                    if (stack == null) {
                        System.out.println("======");
                        System.out.println("A MOD IS RETURNING A NULL STACK. THIS IS NOT ALLOWED YOU NERD. TELL THIS MOD AUTHOR TO FIX IT");
                        System.out.println(container.toString());
                        System.out.println("AT POS " + p.toString());
                        continue;
                    }
                    if (!itemsAvailable.containsKey(stack.m_41720_())) {
                        itemsAvailable.put(stack.m_41720_(), stack.m_41613_());
                        continue;
                    }
                    itemsAvailable.put(stack.m_41720_(), (Integer)itemsAvailable.get(stack.m_41720_()) + stack.m_41613_());
                }
                continue;
            }
            stale.add(p);
        }
        for (BlockPos p : stale) {
            this.inventories.remove(p);
        }
        return itemsAvailable;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("crafting")) {
            this.craftingItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("crafting"));
        }
        this.craftManager = CraftingProgress.read(compound);
        this.entityID = compound.m_128451_("entityid");
        this.hasSource = compound.m_128471_("hasmana");
        this.isOff = compound.m_128471_("off");
        this.isCraftingPotion = compound.m_128471_("isPotion");
        this.needsPotionStorage = compound.m_128471_("storage");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.craftingItem != null) {
            CompoundTag itemTag = new CompoundTag();
            this.craftingItem.m_41739_(itemTag);
            compound.m_128365_("crafting", (Tag)itemTag);
        }
        if (this.craftManager != null) {
            this.craftManager.write(compound);
        }
        compound.m_128405_("entityid", this.entityID);
        compound.m_128379_("hasmana", this.hasSource);
        compound.m_128379_("off", this.isOff);
        compound.m_128379_("isPotion", this.isCraftingPotion);
        compound.m_128379_("storage", this.needsPotionStorage);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        ItemStack potionStack;
        if (this.craftingItem == null) {
            return;
        }
        if (this.isOff) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.tooltip.turned_off"));
        }
        if (!this.isCraftingPotion) {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("ars_nouveau.wixie.crafting").getString() + new TranslatableComponent(this.craftingItem.m_41778_()).getString()));
        } else if (this.craftManager != null && this.craftManager.isPotionCrafting()) {
            potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)this.craftManager.potionOut);
            tooltip.add((Component)new TextComponent(new TranslatableComponent("ars_nouveau.wixie.crafting").getString() + potionStack.m_41786_()));
            PotionUtils.m_43555_((ItemStack)potionStack, tooltip, (float)1.0f);
        }
        if (!this.hasSource) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.wixie.need_mana"));
        }
        if (this.craftManager != null && !this.craftManager.neededItems.isEmpty()) {
            tooltip.add((Component)new TextComponent(new TranslatableComponent("ars_nouveau.wixie.needs").getString() + new TranslatableComponent(this.craftManager.neededItems.get(0).m_41778_()).getString()));
        }
        if (this.craftManager != null && this.craftManager.isPotionCrafting() && !this.craftManager.hasObtainedPotion()) {
            potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)this.craftManager.getPotionNeeded());
            tooltip.add((Component)new TextComponent(new TranslatableComponent("ars_nouveau.wixie.needs").getString() + potionStack.m_41786_().getString()));
        }
        if (this.needsPotionStorage) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.wixie.needs_storage"));
        }
    }

    public boolean isOff() {
        return this.isOff;
    }

    public void setOff(boolean off) {
        this.isOff = off;
        this.updateBlock();
    }

    public static class CraftingProgress {
        public ItemStack outputStack;
        public List<ItemStack> neededItems;
        public List<ItemStack> remainingItems;
        private Potion potionNeeded;
        public Potion potionOut;
        public boolean isPotionCrafting;
        private boolean hasObtainedPotion;

        public CraftingProgress() {
            this.outputStack = ItemStack.f_41583_;
            this.neededItems = new ArrayList<ItemStack>();
            this.remainingItems = new ArrayList<ItemStack>();
        }

        public CraftingProgress(Potion potionNeeded, List<ItemStack> itemsNeeded, Potion potionOut) {
            this.setPotionNeeded(potionNeeded);
            this.potionOut = potionOut;
            this.neededItems = itemsNeeded;
            this.remainingItems = itemsNeeded;
            this.isPotionCrafting = true;
            this.setHasObtainedPotion(false);
            this.outputStack = ItemStack.f_41583_;
        }

        public CraftingProgress(ItemStack outputStack, List<ItemStack> neededItems, Recipe recipe) {
            CraftingContainer inventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

                public boolean m_6875_(Player playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int i = 0; i < neededItems.size(); ++i) {
                inventory.m_6836_(i, neededItems.get(i).m_41777_());
            }
            this.remainingItems = recipe.m_7457_((Container)inventory);
            this.outputStack = outputStack;
            this.neededItems = neededItems;
        }

        public ItemStack getNextItem() {
            return !this.neededItems.isEmpty() ? this.neededItems.get(0) : ItemStack.f_41583_;
        }

        public boolean giveItem(Item i) {
            if (this.isDone()) {
                return false;
            }
            ItemStack stackToRemove = ItemStack.f_41583_;
            for (ItemStack stack : this.neededItems) {
                if (stack.m_41720_() != i) continue;
                stackToRemove = stack;
                break;
            }
            return this.neededItems.remove(stackToRemove);
        }

        public boolean isDone() {
            return !this.isPotionCrafting ? this.neededItems.isEmpty() : this.hasObtainedPotion() && this.neededItems.isEmpty();
        }

        public boolean isPotionCrafting() {
            return this.isPotionCrafting || this.potionOut != Potions.f_43598_ && this.potionOut != null;
        }

        public void write(CompoundTag tag) {
            CompoundTag stack = new CompoundTag();
            this.outputStack.m_41739_(stack);
            tag.m_128365_("output_stack", (Tag)stack);
            NBTUtil.writeItems(tag, "progress", this.neededItems);
            NBTUtil.writeItems(tag, "refund", this.remainingItems);
            CompoundTag outputTag = new CompoundTag();
            PotionUtil.addPotionToTag(this.potionOut, outputTag);
            tag.m_128365_("potionout", (Tag)outputTag);
            CompoundTag neededTag = new CompoundTag();
            PotionUtil.addPotionToTag(this.getPotionNeeded(), neededTag);
            tag.m_128365_("potionNeeded", (Tag)neededTag);
            tag.m_128379_("gotPotion", this.hasObtainedPotion());
            tag.m_128379_("isPotionCraft", this.isPotionCrafting);
        }

        public static CraftingProgress read(CompoundTag tag) {
            CraftingProgress progress = new CraftingProgress();
            progress.outputStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("output_stack"));
            progress.neededItems = NBTUtil.readItems(tag, "progress");
            progress.remainingItems = NBTUtil.readItems(tag, "refund");
            progress.potionOut = PotionUtils.m_43577_((CompoundTag)tag.m_128469_("potionout"));
            progress.setPotionNeeded(PotionUtils.m_43577_((CompoundTag)tag.m_128469_("potionNeeded")));
            progress.setHasObtainedPotion(tag.m_128471_("gotPotion"));
            progress.isPotionCrafting = tag.m_128471_("isPotionCraft");
            return progress;
        }

        public Potion getPotionNeeded() {
            return this.potionNeeded;
        }

        public void setPotionNeeded(Potion potionNeeded) {
            this.potionNeeded = potionNeeded;
        }

        public boolean hasObtainedPotion() {
            return this.hasObtainedPotion || this.potionNeeded == Potions.f_43599_;
        }

        public void setHasObtainedPotion(boolean hasObtainedPotion) {
            this.hasObtainedPotion = hasObtainedPotion;
        }
    }
}

