/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.common.capability.FamiliarData;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ANPlayerDataCap
implements IPlayerCap {
    public Set<AbstractSpellPart> glyphs = new HashSet<AbstractSpellPart>();
    public Set<FamiliarData> familiars = new HashSet<FamiliarData>();

    @Override
    public Collection<AbstractSpellPart> getKnownGlyphs() {
        return this.glyphs;
    }

    @Override
    public void setKnownGlyphs(Collection<AbstractSpellPart> glyphs) {
        this.glyphs = new HashSet<AbstractSpellPart>(glyphs);
    }

    @Override
    public boolean unlockGlyph(AbstractSpellPart spellPart) {
        return this.glyphs.add(spellPart);
    }

    @Override
    public boolean knowsGlyph(AbstractSpellPart spellPart) {
        return this.glyphs.contains(spellPart);
    }

    @Override
    public boolean unlockFamiliar(AbstractFamiliarHolder holderID) {
        return this.familiars.add(new FamiliarData(holderID.id));
    }

    @Override
    public boolean ownsFamiliar(AbstractFamiliarHolder holderID) {
        return this.familiars.stream().anyMatch(f -> f.familiarHolder.getId().equals(holderID.id));
    }

    @Override
    public Collection<FamiliarData> getUnlockedFamiliars() {
        return this.familiars;
    }

    @Override
    public FamiliarData getFamiliarData(String id) {
        return this.familiars.stream().filter(f -> f.familiarHolder.id.equals(id)).findFirst().orElse(null);
    }

    @Override
    public void setUnlockedFamiliars(Collection<FamiliarData> familiars) {
        this.familiars = new HashSet<FamiliarData>(familiars);
    }

    @Override
    public boolean removeFamiliar(AbstractFamiliarHolder holderID) {
        return this.familiars.remove(holderID);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        NBTUtil.writeStrings(tag, "glyph_", this.glyphs.stream().map(s -> s.getId()).collect(Collectors.toList()));
        for (FamiliarData f : this.familiars) {
            tag.m_128365_("familiar_" + f.familiarHolder.id, (Tag)f.toTag());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        for (String s : NBTUtil.readStrings(nbt, "glyph_")) {
            if (!api.getSpellpartMap().containsKey(s)) continue;
            this.glyphs.add(api.getSpellpartMap().get(s));
        }
        for (String s : nbt.m_128431_()) {
            if (!s.contains("familiar_")) continue;
            this.familiars.add(new FamiliarData(nbt.m_128469_(s)));
        }
    }

    public static ANPlayerDataCap deserialize(CompoundTag tag) {
        ANPlayerDataCap cap = new ANPlayerDataCap();
        cap.deserializeNBT(tag);
        return cap;
    }
}

