/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.crafting.recipes.RecipeUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BookUpgradeRecipe
extends ShapelessRecipe {
    private BookUpgradeRecipe(ResourceLocation id, String group, ItemStack recipeOutput, NonNullList<Ingredient> ingredients) {
        super(id, group, recipeOutput, ingredients);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack output = super.m_5874_(inv);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof SpellBook)) continue;
                output.m_41751_(ingredient.m_41783_());
            }
        }
        return output;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeRegistry.BOOK_UPGRADE_RECIPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<BookUpgradeRecipe> {
        public BookUpgradeRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new BookUpgradeRecipe(recipeID, group, result, ingredients);
        }

        public BookUpgradeRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int numIngredients = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new BookUpgradeRecipe(recipeID, group, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, BookUpgradeRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

