/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.familiar.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.SummonBed;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.AvoidEntityGoalMC;
import com.hollingsworth.arsnouveau.common.entity.goal.GetUnstuckGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.FindItem;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.ForageManaBerries;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToBedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NonHoggingLook;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StoreItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.TakeItemGoal;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MovementHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingStuckHandler;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;

public class Starbuncle
extends PathfinderMob
implements IAnimatable,
IDecoratable,
IDispellable,
ITooltipProvider,
IWandable {
    public StarbuncleGoalState goalState;
    public List<ItemStack> allowedItems = new ArrayList<ItemStack>();
    public List<ItemStack> ignoreItems = new ArrayList<ItemStack>();
    public Block pathBlock;
    public boolean whitelist;
    public boolean blacklist;
    public List<BlockPos> TO_LIST = new ArrayList<BlockPos>();
    public List<BlockPos> FROM_LIST = new ArrayList<BlockPos>();
    public BlockPos bedPos;
    private MinecoloniesAdvancedPathNavigate pathNavigate;
    public static final EntityDataAccessor<Integer> TO_POS_SIZE = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FROM_POS_SIZE = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> PATH_BLOCK = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<ItemStack> HEAD_COSMETIC = SynchedEntityData.m_135353_(Starbuncle.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int backOff;
    public int tamingTime;
    public boolean isStuck;
    private int lastAABBCalc;
    private AABB cachedAAB;
    public BlockPos jukeboxPos;
    public boolean partyCarby;
    public PathNavigation minecraftPathNav;
    AnimationFactory manager = new AnimationFactory(this);
    private boolean setBehaviors;
    public static String[] carbyColors = new String[]{"purple", "orange", "blue", "red", "yellow", "green"};

    public Starbuncle(EntityType<Starbuncle> entityCarbuncleEntityType, Level world) {
        super(entityCarbuncleEntityType, world);
        this.f_19793_ = 1.2f;
        this.addGoalsAfterConstructor();
        this.f_21342_ = new MovementHandler((Mob)this);
    }

    public Starbuncle(Level world, boolean tamed) {
        super(ModEntities.STARBUNCLE_TYPE, world);
        this.setTamed(tamed);
        this.f_19793_ = 1.2f;
        this.f_21342_ = new MovementHandler((Mob)this);
        this.addGoalsAfterConstructor();
    }

    public MinecoloniesAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = new MinecoloniesAdvancedPathNavigate((Mob)this, this.f_19853_);
            this.minecraftPathNav = this.f_21344_;
            this.f_21344_ = this.pathNavigate;
            this.pathNavigate.m_7008_(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
            this.pathNavigate.getPathingOptions().setCanFitInOneCube(true);
            this.pathNavigate.getPathingOptions().onPathCost = 0.1;
            this.pathNavigate.getPathingOptions().withRoadState(this::isOnRoad);
        }
        return this.pathNavigate;
    }

    public Boolean isOnRoad(BlockState state) {
        return state.m_60734_() instanceof DirtPathBlock || this.pathBlock != null && this.pathBlock == state.m_60734_();
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController<Starbuncle>(this, "walkController", 1.0f, this::animationPredicate));
        animationData.addAnimationController(new AnimationController<Starbuncle>(this, "danceController", 1.0f, this::dancePredicate));
        animationData.addAnimationController(new AnimationController<Starbuncle>(this, "sleepController", 1.0f, this::sleepPredicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.manager;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    private PlayState dancePredicate(AnimationEvent event) {
        if (this.partyCarby && this.jukeboxPos != null && BlockUtil.distanceFrom(this.f_19825_, this.jukeboxPos) <= 8.0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dance_master"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState animationPredicate(AnimationEvent event) {
        if (event.isMoving() || this.f_19853_.f_46443_ && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends IAnimatable> PlayState sleepPredicate(AnimationEvent<T> event) {
        Block onBlock = this.f_19853_.m_8055_(new BlockPos(this.f_19825_)).m_60734_();
        if (!event.isMoving() && (onBlock instanceof BedBlock || onBlock instanceof SummonBed)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("resting"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    public String pathBlockDesc() {
        return (String)this.f_19804_.m_135370_(PATH_BLOCK);
    }

    public void setPathBlockDesc(String name) {
        this.f_19804_.m_135381_(PATH_BLOCK, (Object)name);
    }

    public void attemptTame() {
        if (!this.isTamed() && this.getHeldStack().m_41720_() == Items.f_42587_) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.f_19853_.m_5776_()) {
                Networking.sendToNearby(this.f_19853_, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.m_142538_(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.f_19853_.f_46443_) {
                ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_SHARD, 1 + this.f_19853_.f_46441_.nextInt(2));
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.f_19853_.f_46443_) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.m_20185_();
                    double d1 = this.m_20186_() + 0.1;
                    double d2 = this.m_20189_();
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, ((double)(this.f_19853_.f_46441_.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.f_19853_.f_46441_.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.f_19853_.f_46441_.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    public void m_8119_() {
        try {
            super.m_8119_();
        }
        catch (NoClassDefFoundError error) {
            System.out.println("Starbuncle threaded pathing failed.");
            System.out.println(this);
            return;
        }
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 10L == 0L && this.m_7755_().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.f_19804_.m_135381_(COLOR, (Object)carbyColors[this.f_19853_.f_46441_.nextInt(carbyColors.length)]);
        }
        if (!this.f_19853_.f_46443_) {
            ++this.lastAABBCalc;
        }
        if (this.backOff > 0 && !this.f_19853_.f_46443_) {
            --this.backOff;
        }
        if (this.f_20890_) {
            return;
        }
        if (this.getHeldStack().m_41619_() && !this.f_19853_.f_46443_) {
            for (ItemEntity itementity : this.f_19853_.m_45976_(ItemEntity.class, this.m_142469_().m_82400_(1.0))) {
                if (!itementity.m_6084_() || itementity.m_32055_().m_41619_() || itementity.m_32063_()) continue;
                if (!this.isTamed() && itementity.m_32055_().m_41720_() != Items.f_42587_) {
                    return;
                }
                this.m_7581_(itementity);
                if (this.getHeldStack() == null || this.getHeldStack().m_41619_()) continue;
                break;
            }
        }
        this.attemptTame();
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.whitelist = false;
        this.blacklist = false;
        this.FROM_LIST = new ArrayList<BlockPos>();
        this.TO_LIST = new ArrayList<BlockPos>();
        this.allowedItems = new ArrayList<ItemStack>();
        this.ignoreItems = new ArrayList<ItemStack>();
        this.f_19804_.m_135381_(TO_POS_SIZE, (Object)0);
        this.f_19804_.m_135381_(FROM_POS_SIZE, (Object)0);
        this.pathBlock = null;
        this.bedPos = null;
        PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.starbuncle.cleared"));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.f_19853_.m_7702_(storedPos) != null && this.f_19853_.m_7702_(storedPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.starbuncle.store"));
            this.setToPos(storedPos);
        }
        if (this.f_19853_.m_8055_(storedPos).m_60734_() instanceof SummonBed) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.starbuncle.set_bed"));
            this.bedPos = storedPos.m_7949_();
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.f_19853_.m_7702_(storedPos) != null && this.f_19853_.m_7702_(storedPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.starbuncle.take"));
            this.setFromPos(storedPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (this.getHeldStack().m_41619_() && this.isValidItem(itemEntity.m_32055_())) {
            this.setHeldStack(itemEntity.m_32055_());
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, this.m_5720_(), 1.0f, 1.0f);
            if (!this.isTamed()) {
                return;
            }
            for (ItemEntity i : this.f_19853_.m_45976_(ItemEntity.class, this.m_142469_().m_82400_(3.0))) {
                if (itemEntity.m_32055_().m_41613_() >= itemEntity.m_32055_().m_41741_()) break;
                int maxTake = this.getHeldStack().m_41741_() - this.getHeldStack().m_41613_();
                if (!i.m_32055_().m_41656_(this.getHeldStack())) continue;
                int toTake = Math.min(i.m_32055_().m_41613_(), maxTake);
                i.m_32055_().m_41774_(toTake);
                this.getHeldStack().m_41769_(toTake);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6818_(BlockPos pos, boolean hasSound) {
        super.m_6818_(pos, hasSound);
        this.jukeboxPos = pos;
        this.partyCarby = hasSound;
    }

    protected void addGoalsAfterConstructor() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (WrappedGoal goal : this.getGoals()) {
            this.f_21345_.m_25352_(goal.m_26012_(), goal.m_26015_());
        }
    }

    public List<WrappedGoal> getGoals() {
        return Boolean.TRUE.equals(this.f_19804_.m_135370_(TAMED)) ? this.getTamedGoals() : this.getUntamedGoals();
    }

    protected float m_6108_() {
        return 0.875f;
    }

    public List<WrappedGoal> getTamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(1, (Goal)new GetUnstuckGoal((Mob)this, () -> this.isStuck, stuck -> {
            this.isStuck = stuck;
            return null;
        })));
        list.add(new WrappedGoal(1, (Goal)new FindItem(this)));
        list.add(new WrappedGoal(2, (Goal)new ForageManaBerries(this)));
        list.add(new WrappedGoal(3, (Goal)new StoreItemGoal(this)));
        list.add(new WrappedGoal(3, (Goal)new TakeItemGoal(this)));
        list.add(new WrappedGoal(4, (Goal)new GoToBedGoal(this)));
        list.add(new WrappedGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 0.01f)));
        list.add(new WrappedGoal(8, (Goal)new NonHoggingLook(this, Mob.class, 3.0f, 0.01f)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        list.add(new WrappedGoal(1, (Goal)new OpenDoorGoal((Mob)this, true)));
        return list;
    }

    public List<WrappedGoal> getUntamedGoals() {
        ArrayList<WrappedGoal> list = new ArrayList<WrappedGoal>();
        list.add(new WrappedGoal(1, (Goal)new FindItem(this)));
        list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 0.02f)));
        list.add(new WrappedGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f)));
        list.add(new WrappedGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2)));
        list.add(new WrappedGoal(2, new AvoidEntityGoalMC<Player>(this, Player.class, 16.0f, 2.0, 1.2)));
        list.add(new WrappedGoal(0, (Goal)new FloatGoal((Mob)this)));
        return list;
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_CHARM);
            stack.m_41751_(Starbuncle.getStarbuncleData(this).toTag(new CompoundTag()));
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
            if (this.getHeldStack() != null) {
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getHeldStack()));
            }
            if (!this.getCosmeticItem().m_41619_()) {
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getCosmeticItem().m_41777_()));
            }
        }
        super.m_6667_(source);
    }

    public AABB getAABB() {
        if (this.cachedAAB == null || this.lastAABBCalc >= 60) {
            this.cachedAAB = new AABB(this.m_142538_()).m_82400_(8.0);
            this.lastAABBCalc = 0;
        }
        return this.cachedAAB;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        List<ItemStack> items;
        if (hand != InteractionHand.MAIN_HAND || player.m_20193_().f_46443_ || !this.isTamed()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21205_().m_204117_(Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.f_19804_.m_135370_(COLOR)).equals(color.m_41065_()) || !Arrays.asList(carbyColors).contains(color.m_41065_())) {
                return InteractionResult.SUCCESS;
            }
            this.f_19804_.m_135381_(COLOR, (Object)color.m_41065_());
            player.m_21205_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() instanceof BlockItem) {
            this.pathBlock = ((BlockItem)player.m_21205_().m_41720_()).m_40614_();
            this.setPathBlockDesc(new TranslatableComponent(this.pathBlock.m_7705_()).getString());
            PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.starbuncle.path"));
        }
        if (player.m_21205_().m_41619_() && this.isTamed()) {
            StringBuilder status = new StringBuilder();
            if (this.whitelist && this.allowedItems != null) {
                status.append(new TranslatableComponent("ars_nouveau.starbuncle.whitelist").getString());
                for (ItemStack i : this.allowedItems) {
                    status.append(i.m_41786_().getString());
                }
            } else if (this.blacklist && this.allowedItems != null) {
                status.append(new TranslatableComponent("ars_nouveau.starbuncle.blacklist").getString());
                for (ItemStack i : this.ignoreItems) {
                    status.append(i.m_41786_().getString());
                }
            }
            if (!status.toString().isEmpty()) {
                PortUtil.sendMessage((Entity)player, status.toString());
            }
        }
        if (!(stack.m_41720_() instanceof ItemScroll) || !stack.m_41782_()) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41720_() == ItemsRegistry.ALLOW_ITEM_SCROLL) {
            items = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
            if (!items.isEmpty()) {
                this.allowedItems = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
                this.whitelist = true;
                this.blacklist = false;
                PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.allow_set"));
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == ItemsRegistry.DENY_ITEM_SCROLL && !(items = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack)).isEmpty()) {
            this.ignoreItems = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack);
            this.whitelist = false;
            this.blacklist = true;
            PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.ignore_set"));
        }
        return InteractionResult.SUCCESS;
    }

    public EntityType<?> m_6095_() {
        return ModEntities.STARBUNCLE_TYPE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(TO_POS_SIZE, (Object)0);
        this.f_19804_.m_135372_(FROM_POS_SIZE, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)COLORS.ORANGE.name());
        this.f_19804_.m_135372_(PATH_BLOCK, (Object)"");
        this.f_19804_.m_135372_(HEAD_COSMETIC, (Object)ItemStack.f_41583_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void setHeldStack(ItemStack stack) {
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    public ItemStack getHeldStack() {
        return this.m_21205_();
    }

    @Override
    public ItemStack getCosmeticItem() {
        return (ItemStack)this.f_19804_.m_135370_(HEAD_COSMETIC);
    }

    @Override
    public void setCosmeticItem(ItemStack stack) {
        if (!((ItemStack)this.f_19804_.m_135370_(HEAD_COSMETIC)).m_41619_()) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (ItemStack)this.f_19804_.m_135370_(HEAD_COSMETIC)));
        }
        this.f_19804_.m_135381_(HEAD_COSMETIC, (Object)stack);
    }

    public boolean isPickupDisabled() {
        return this.getCosmeticItem().m_41720_() == ItemsRegistry.STARBUNCLE_SHADES;
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_146910_()) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.isTamed()) {
            ItemStack charm = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_CHARM);
            charm.m_41751_(Starbuncle.getStarbuncleData(this).toTag(new CompoundTag()));
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), charm.m_41777_()));
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getHeldStack()));
            if (!this.getCosmeticItem().m_41619_()) {
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getCosmeticItem().m_41777_()));
            }
            ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_142538_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public static StarbuncleData getStarbuncleData(Starbuncle starbuncle) {
        CompoundTag starbyTag = new CompoundTag();
        starbuncle.m_7380_(starbyTag);
        StarbuncleData data = new StarbuncleData(starbyTag);
        data.name = starbuncle.m_7770_();
        return data;
    }

    public void m_7378_(CompoundTag tag) {
        BlockPos pos;
        super.m_7378_(tag);
        if (tag.m_128441_("headCosmetic")) {
            this.f_19804_.m_135381_(HEAD_COSMETIC, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("headCosmetic")));
        }
        if (tag.m_128441_("held")) {
            this.setHeldStack(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("held"))));
        }
        this.FROM_LIST = new ArrayList<BlockPos>();
        this.TO_LIST = new ArrayList<BlockPos>();
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.FROM_LIST.contains(pos)) {
                this.FROM_LIST.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.TO_LIST.contains(pos)) {
                this.TO_LIST.add(pos);
            }
            ++counter;
        }
        this.backOff = tag.m_128451_("backoff");
        this.tamingTime = tag.m_128451_("taming_time");
        this.whitelist = tag.m_128471_("whitelist");
        this.blacklist = tag.m_128471_("blacklist");
        if (!this.setBehaviors) {
            this.removeGoals();
        }
        this.f_19804_.m_135381_(TAMED, (Object)tag.m_128471_("tamed"));
        if (!this.setBehaviors) {
            this.addGoalsAfterConstructor();
            this.setBehaviors = true;
        }
        this.allowedItems = NBTUtil.readItems(tag, "allowed_");
        this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
        this.isStuck = tag.m_128471_("stuck");
        if (tag.m_128441_("color")) {
            this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        }
        this.f_19804_.m_135381_(TO_POS_SIZE, (Object)this.TO_LIST.size());
        this.f_19804_.m_135381_(FROM_POS_SIZE, (Object)this.FROM_LIST.size());
        if (tag.m_128441_("path")) {
            this.pathBlock = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(tag.m_128461_("path")));
            this.setPathBlockDesc(new TranslatableComponent(this.pathBlock.m_7705_()).getString());
        }
        this.bedPos = NBTUtil.getBlockPos(tag, "bed_");
        if (this.bedPos.equals((Object)BlockPos.f_121853_)) {
            this.bedPos = null;
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getHeldStack() != null) {
            CompoundTag itemTag = new CompoundTag();
            this.getHeldStack().m_41739_(itemTag);
            tag.m_128365_("held", (Tag)itemTag);
        }
        if (!((ItemStack)this.f_19804_.m_135370_(HEAD_COSMETIC)).m_41619_()) {
            CompoundTag cosmeticTag = new CompoundTag();
            ((ItemStack)this.f_19804_.m_135370_(HEAD_COSMETIC)).m_41739_(cosmeticTag);
            tag.m_128365_("headCosmetic", (Tag)cosmeticTag);
        }
        int counter = 0;
        for (BlockPos p : this.FROM_LIST) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, p);
            ++counter;
        }
        counter = 0;
        for (BlockPos p : this.TO_LIST) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, p);
            ++counter;
        }
        tag.m_128405_("backoff", this.backOff);
        tag.m_128379_("tamed", ((Boolean)this.f_19804_.m_135370_(TAMED)).booleanValue());
        tag.m_128405_("taming_time", this.tamingTime);
        tag.m_128379_("whitelist", this.whitelist);
        tag.m_128379_("blacklist", this.blacklist);
        if (this.allowedItems != null && !this.allowedItems.isEmpty()) {
            NBTUtil.writeItems(tag, "allowed_", this.allowedItems);
        }
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
        }
        tag.m_128379_("stuck", this.isStuck);
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
        if (this.pathBlock != null) {
            tag.m_128359_("path", this.pathBlock.getRegistryName().toString());
        }
        NBTUtil.storeBlockPos(tag, "bed_", this.bedPos);
    }

    public void removeGoals() {
        this.f_21345_.f_25345_ = new LinkedHashSet();
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (!this.isTamed()) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.starbuncle.storing", new Object[]{this.f_19804_.m_135370_(TO_POS_SIZE)}));
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.starbuncle.taking", new Object[]{this.f_19804_.m_135370_(FROM_POS_SIZE)}));
        if (this.pathBlockDesc() != null && !this.pathBlockDesc().isEmpty()) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.starbuncle.pathing", new Object[]{this.f_19804_.m_135370_(PATH_BLOCK)}));
        }
    }

    private ItemScroll.SortPref canDepositItem(BlockEntity tile, ItemStack stack) {
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (tile == null || stack == null || stack.m_41619_()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrame i : this.f_19853_.m_45976_(ItemFrame.class, new AABB(tile.m_58899_()).m_82400_(1.0))) {
            BlockEntity adjTile = this.f_19853_.m_7702_(i.m_142538_().m_142300_(i.m_6350_().m_122424_()));
            if (adjTile == null || !adjTile.equals(tile) || i.m_31822_().m_41619_()) continue;
            ItemStack stackInFrame = i.m_31822_();
            if (stackInFrame.m_41720_() instanceof ItemScroll) {
                pref = ((ItemScroll)stackInFrame.m_41720_()).getSortPref(stack, stackInFrame.m_41784_(), handler);
                continue;
            }
            if (i.m_31822_().m_41720_() != stack.m_41720_()) {
                return ItemScroll.SortPref.INVALID;
            }
            if (i.m_31822_().m_41720_() != stack.m_41720_()) continue;
            pref = ItemScroll.SortPref.HIGHEST;
        }
        return !ItemStack.m_41728_((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    protected int m_6552_(Player player) {
        return 0;
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        if (this.TO_LIST == null) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : this.TO_LIST) {
            ItemScroll.SortPref pref = this.isValidStorePos(b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
        }
        return returnPos;
    }

    public ItemScroll.SortPref isValidStorePos(@Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.m_41619_() || b == null) {
            return ItemScroll.SortPref.INVALID;
        }
        return this.canDepositItem(this.f_19853_.m_7702_(b), stack);
    }

    @Nullable
    public BlockPos getValidTakePos() {
        if (this.FROM_LIST == null) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidTake(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null || this.f_19853_.m_7702_(p) == null) {
            return false;
        }
        IItemHandler iItemHandler = (IItemHandler)this.f_19853_.m_7702_(p).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (iItemHandler == null) {
            return false;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            if (iItemHandler.getStackInSlot(j).m_41619_() || !this.isValidItem(iItemHandler.getStackInSlot(j)) || this.getValidStorePos(iItemHandler.getStackInSlot(j)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity p_241849_1_) {
        return true;
    }

    public int getMaxTake(ItemStack stack) {
        if (!this.isValidItem(stack)) {
            return -1;
        }
        BlockPos validStorePos = this.getValidStorePos(stack);
        if (validStorePos == null) {
            return -1;
        }
        IItemHandler handler = (IItemHandler)this.f_19853_.m_7702_(validStorePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler == null) {
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack handlerStack = handler.getStackInSlot(i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)handler.getStackInSlot(i), (ItemStack)stack) && !handlerStack.m_41619_()) continue;
            if (handlerStack.m_41619_()) {
                return handler.getSlotLimit(i);
            }
            int maxRoom = handlerStack.m_41741_() - handlerStack.m_41613_();
            if (maxRoom <= 0) continue;
            return Math.min(maxRoom, handler.getSlotLimit(i));
        }
        return -1;
    }

    public boolean isValidItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!this.isTamed() && stack.m_41720_() == Items.f_42587_) {
            return true;
        }
        if (this.getValidStorePos(stack) == null) {
            return false;
        }
        if (!this.whitelist && !this.blacklist) {
            return true;
        }
        if (this.whitelist) {
            for (ItemStack s : this.allowedItems) {
                if (!s.m_41656_(stack)) continue;
                return true;
            }
            return false;
        }
        for (ItemStack s : this.ignoreItems) {
            if (!s.m_41656_(stack)) continue;
            return false;
        }
        return true;
    }

    public void setFromPos(BlockPos fromPos) {
        if (!this.FROM_LIST.contains(fromPos)) {
            this.FROM_LIST.add(fromPos.m_7949_());
        }
        this.f_19804_.m_135381_(FROM_POS_SIZE, (Object)this.FROM_LIST.size());
    }

    public void setToPos(BlockPos toPos) {
        if (!this.TO_LIST.contains(toPos)) {
            this.TO_LIST.add(toPos.m_7949_());
        }
        this.f_19804_.m_135381_(TO_POS_SIZE, (Object)this.TO_LIST.size());
    }

    public int getBackOff() {
        return this.backOff;
    }

    public void setBackOff(int backOff) {
        this.backOff = backOff;
    }

    public static class StarbuncleData
    extends PersistentFamiliarData<Starbuncle> {
        public List<BlockPos> TO_LIST = new ArrayList<BlockPos>();
        public List<BlockPos> FROM_LIST = new ArrayList<BlockPos>();
        public List<ItemStack> allowedItems = new ArrayList<ItemStack>();
        public List<ItemStack> ignoreItems = new ArrayList<ItemStack>();
        public Block pathBlock;
        public BlockPos bedPos;
        public boolean whitelist;
        public boolean blacklist;

        public StarbuncleData(CompoundTag tag) {
            super(tag);
            BlockPos pos;
            this.FROM_LIST = new ArrayList<BlockPos>();
            this.TO_LIST = new ArrayList<BlockPos>();
            int counter = 0;
            while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
                pos = NBTUtil.getBlockPos(tag, "from_" + counter);
                if (!this.FROM_LIST.contains(pos)) {
                    this.FROM_LIST.add(pos);
                }
                ++counter;
            }
            counter = 0;
            while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
                pos = NBTUtil.getBlockPos(tag, "to_" + counter);
                if (!this.TO_LIST.contains(pos)) {
                    this.TO_LIST.add(pos);
                }
                ++counter;
            }
            this.whitelist = tag.m_128471_("whitelist");
            this.blacklist = tag.m_128471_("blacklist");
            if (tag.m_128441_("path")) {
                this.pathBlock = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(tag.m_128461_("path")));
            }
            this.allowedItems = NBTUtil.readItems(tag, "allowed_");
            this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
            this.bedPos = NBTUtil.getBlockPos(tag, "bed_");
            if (this.bedPos.equals((Object)BlockPos.f_121853_)) {
                this.bedPos = null;
            }
        }

        @Override
        public CompoundTag toTag(CompoundTag tag) {
            super.toTag(tag);
            int counter = 0;
            for (BlockPos p : this.FROM_LIST) {
                NBTUtil.storeBlockPos(tag, "from_" + counter, p);
                ++counter;
            }
            counter = 0;
            for (BlockPos p : this.TO_LIST) {
                NBTUtil.storeBlockPos(tag, "to_" + counter, p);
                ++counter;
            }
            tag.m_128379_("whitelist", this.whitelist);
            tag.m_128379_("blacklist", this.blacklist);
            if (this.allowedItems != null && !this.allowedItems.isEmpty()) {
                NBTUtil.writeItems(tag, "allowed_", this.allowedItems);
            }
            if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
                NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
            }
            if (this.pathBlock != null) {
                tag.m_128359_("path", this.pathBlock.getRegistryName().toString());
            }
            if (this.bedPos != null) {
                NBTUtil.storeBlockPos(tag, "bed_", this.bedPos);
            }
            return tag;
        }
    }

    public static enum COLORS {
        ORANGE,
        PURPLE,
        GREEN,
        BLUE,
        RED,
        YELLOW;

    }

    public static enum StarbuncleGoalState {
        FORAGING,
        HUNTING_ITEM,
        TAKING_ITEM,
        STORING_ITEM,
        RESTING,
        NONE;

    }
}

