/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandlerEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    public static final List<Direction> HORIZONTAL_DIRS = Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    private static final int MAX_TP_DELAY = 6000;
    private static final int MIN_DIST_FOR_TP = 10;
    private int teleportRange = 0;
    private int timePerBlockDistance = 200;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.f_121853_;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 200;
    private Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)BlockPos.f_121853_)) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (navigator.getOurEntity() instanceof IStuckHandlerEntity && !((IStuckHandlerEntity)navigator.getOurEntity()).canBeStuck()) {
            return;
        }
        double distanceToGoal = navigator.getOurEntity().m_20182_().m_82554_(new Vec3((double)navigator.getDesiredPos().m_123341_(), (double)navigator.getDesiredPos().m_123342_(), (double)navigator.getDesiredPos().m_123343_()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.min(6000.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.m_26570_() == null || navigator.m_26570_().m_77392_()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.m_26570_().m_77399_() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1 && navigator.m_26570_().m_77406_().m_123331_((Vec3i)this.prevDestination) < 25.0) {
            int n = this.progressedNodes = navigator.m_26570_().m_77399_() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
            if (this.progressedNodes > 5) {
                this.resetStuckTimers();
            }
        }
        this.lastPathIndex = navigator.m_26570_() != null ? navigator.m_26570_().m_77399_() : -1;
        this.hadPath = navigator.m_26570_() != null && !navigator.m_26570_().m_77392_();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.f_121853_;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        BlockPos desired = navigator.getDesiredPos();
        Level world = navigator.getOurEntity().f_19853_;
        Mob entity = navigator.getOurEntity();
        if (this.canTeleportGoal) {
            for (Direction dir : HORIZONTAL_DIRS) {
                if (!world.m_46859_(desired.m_142300_(dir)) || !world.m_46859_(desired.m_142300_(dir).m_7494_())) continue;
                entity.m_6021_((double)desired.m_142300_(dir).m_123341_() + 0.5, (double)desired.m_142300_(dir).m_123342_(), (double)desired.m_142300_(dir).m_123343_() + 0.5);
                break;
            }
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.m_6469_((DamageSource)new EntityDamageSource("Stuck-damage", (Entity)entity), entity.m_21233_() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            Direction facing = PathingStuckHandler.getFacing(new BlockPos(entity.m_20182_()), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.m_46859_(new BlockPos(entity.m_20182_()).m_5484_(facing, i)) && world.m_46859_(new BlockPos(entity.m_20182_()).m_5484_(facing, i).m_7494_())) continue;
                this.breakBlocksAhead(world, new BlockPos(entity.m_20182_()).m_5484_(facing, i - 1), facing);
                break;
            }
        }
        navigator.m_26573_();
        this.resetGlobalStuckTimers();
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.m_141950_((Vec3i)pos);
        return Direction.m_122372_((float)vector.m_123341_(), (float)vector.m_123342_(), (float)(-vector.m_123343_()));
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction-- > 0) {
            return;
        }
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 600;
            navigator.m_26573_();
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.m_26570_().m_77399_() + this.teleportRange, navigator.m_26570_().m_77398_() - 1);
            Node togo = navigator.m_26570_().m_77375_(index);
            navigator.getOurEntity().m_6021_((double)togo.f_77271_ + 0.5, (double)togo.f_77272_, (double)togo.f_77273_ + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 8) {
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel -= 2;
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
    }

    private void breakBlocksAhead(Level world, BlockPos start, Direction facing) {
        if (!world.m_46859_(start.m_6630_(3))) {
            this.setAirIfPossible(world, start.m_6630_(3));
            return;
        }
        if (!world.m_46859_(start.m_142300_(facing))) {
            this.setAirIfPossible(world, start.m_142300_(facing));
            return;
        }
        if (!world.m_46859_(start.m_7494_().m_142300_(facing))) {
            this.setAirIfPossible(world, start.m_7494_().m_142300_(facing));
        }
    }

    private void setAirIfPossible(Level world, BlockPos pos) {
        Block blockAtPos = world.m_8055_(pos).m_60734_();
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }
}

