/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketUpdateSpellColors {
    int castSlot;
    int r;
    int g;
    int b;

    public PacketUpdateSpellColors(int castSlot, int r, int g, int b) {
        this.castSlot = castSlot;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public PacketUpdateSpellColors(FriendlyByteBuf buf) {
        this.castSlot = buf.readInt();
        this.r = buf.readInt();
        this.g = buf.readInt();
        this.b = buf.readInt();
    }

    public PacketUpdateSpellColors(int slot, double red, double green, double blue) {
        this(slot, (int)red, (int)green, (int)blue);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.castSlot);
        buf.writeInt(this.r);
        buf.writeInt(this.g);
        buf.writeInt(this.b);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            if (((NetworkEvent.Context)ctx.get()).getSender() != null && (stack = StackUtil.getHeldSpellbook((Player)((NetworkEvent.Context)ctx.get()).getSender())).m_41720_() instanceof SpellBook) {
                ISpellCaster caster = CasterUtil.getCaster(stack);
                caster.setColor(new ParticleColor.IntWrapper(this.r, this.g, this.b), this.castSlot);
                caster.setCurrentSlot(this.castSlot);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketUpdateSpellColors.lambda$handle$0((Supplier)ctx)), (Object)new PacketUpdateBookGUI(stack));
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketUpdateSpellColors.lambda$handle$1((Supplier)ctx)), (Object)new PacketOpenSpellBook(stack, ((SpellBook)stack.m_41720_()).tier.value));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ ServerPlayer lambda$handle$1(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }
}

