/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;

public abstract class GeoBlockRenderer<T extends BlockEntity>
implements IGeoRenderer<T>,
BlockEntityRenderer {
    protected final AnimatedGeoModel<T> modelProvider;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected T animatable;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    protected MultiBufferSource rtb = null;

    public GeoBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn, AnimatedGeoModel<T> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void m_6922_(BlockEntity tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.render(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
    }

    public void render(T tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(tile));
        this.modelProvider.setLivingAnimations(tile, this.getUniqueID(tile));
        this.dispatchedMat = stack.m_85850_().m_85861_().m_27658_();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        stack.m_85836_();
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        stack.m_85837_(0.5, 0.0, 0.5);
        this.rotateBlock(this.getFacing(tile), stack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(tile));
        Color renderColor = this.getRenderColor(tile, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(tile, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(tile));
        this.render(model, tile, partialTicks, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        stack.m_85849_();
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = stackIn.m_85850_().m_85861_().m_27658_();
        this.animatable = animatable;
        IGeoRenderer.super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f boneMat = entry.m_85861_().m_27658_();
            Matrix4f renderEarlyMatInvert = this.renderEarlyMat.m_27658_();
            renderEarlyMatInvert.m_27657_();
            Matrix4f modelPosBoneMat = boneMat.m_27658_();
            modelPosBoneMat.multiplyBackward(renderEarlyMatInvert);
            bone.setModelSpaceXform(modelPosBoneMat);
            Matrix4f dispatchedMatInvert = this.dispatchedMat.m_27658_();
            dispatchedMatInvert.m_27657_();
            Matrix4f localPosBoneMat = boneMat.m_27658_();
            localPosBoneMat.multiplyBackward(dispatchedMatInvert);
            Vec3 renderOffset = this.getRenderOffset(this.animatable, 1.0f);
            localPosBoneMat.m_27648_(new Vector3f((float)renderOffset.m_7096_(), (float)renderOffset.m_7098_(), (float)renderOffset.m_7094_()));
            bone.setLocalSpaceXform(localPosBoneMat);
            Matrix4f worldPosBoneMat = localPosBoneMat.m_27658_();
            worldPosBoneMat.m_27648_(new Vector3f((float)this.animatable.m_58899_().m_123341_(), (float)this.animatable.m_58899_().m_123342_(), (float)this.animatable.m_58899_().m_123343_()));
            bone.setWorldSpaceXform(worldPosBoneMat);
        }
        IGeoRenderer.super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public Vec3 getRenderOffset(T pEntity, float pPartialTicks) {
        return Vec3.f_82478_;
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.m_58899_().hashCode();
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    @Nonnull
    @ApiStatus.AvailableSince(value="3.0.42")
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getWidthScale(T entity) {
        return this.widthScale;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    protected void rotateBlock(Direction facing, PoseStack stack) {
        switch (facing) {
            case SOUTH: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case NORTH: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
                break;
            }
            case EAST: {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                break;
            }
            case UP: {
                stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case DOWN: {
                stack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
            }
        }
    }

    private Direction getFacing(T tile) {
        BlockState blockState = tile.m_58900_();
        if (blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (blockState.m_61138_((Property)DirectionalBlock.f_52588_)) {
            return (Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_);
        }
        return Direction.NORTH;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    @Override
    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof BlockEntity) {
                BlockEntity tile = (BlockEntity)object;
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(tile);
                if (renderer instanceof GeoBlockRenderer) {
                    return ((GeoBlockRenderer)renderer).getGeoModelProvider();
                }
            }
            return null;
        });
    }
}

