/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatableModel;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.model.provider.GeoModelProvider;
import software.bernie.ars_nouveau.geckolib3.model.provider.data.EntityModelData;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.ars_nouveau.geckolib3.util.AnimationUtils;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;

public class GeoProjectilesRenderer<T extends Entity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected T animatable;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;
    protected MultiBufferSource rtb = null;

    public GeoProjectilesRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entityIn));
        this.dispatchedMat = matrixStackIn.m_85850_().m_85861_().m_27658_();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((Entity)entityIn).f_19859_, (float)entityIn.m_146908_()) - 90.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((Entity)entityIn).f_19860_, (float)entityIn.m_146909_())));
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        EntityModelData entityModelData = new EntityModelData();
        AnimationEvent<T> predicate = new AnimationEvent<T>(entityIn, limbSwing, lastLimbDistance, partialTicks, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entityIn, this.getUniqueID(entityIn), (AnimationEvent)predicate);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.m_5478_(entityIn));
        Color renderColor = this.getRenderColor(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.m_5478_(entityIn));
        if (!entityIn.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            this.render(model, entityIn, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, GeoProjectilesRenderer.getPackedOverlay(entityIn, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = stackIn.m_85850_().m_85861_().m_27658_();
        this.animatable = animatable;
        IGeoRenderer.super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f boneMat = entry.m_85861_().m_27658_();
            Matrix4f renderEarlyMatInvert = this.renderEarlyMat.m_27658_();
            renderEarlyMatInvert.m_27657_();
            Matrix4f modelPosBoneMat = boneMat.m_27658_();
            modelPosBoneMat.multiplyBackward(renderEarlyMatInvert);
            bone.setModelSpaceXform(modelPosBoneMat);
            Matrix4f dispatchedMatInvert = this.dispatchedMat.m_27658_();
            dispatchedMatInvert.m_27657_();
            Matrix4f localPosBoneMat = boneMat.m_27658_();
            localPosBoneMat.multiplyBackward(dispatchedMatInvert);
            Vec3 renderOffset = this.m_7860_((Entity)this.animatable, 1.0f);
            localPosBoneMat.m_27648_(new Vector3f((float)renderOffset.m_7096_(), (float)renderOffset.m_7098_(), (float)renderOffset.m_7094_()));
            bone.setLocalSpaceXform(localPosBoneMat);
            Matrix4f worldPosBoneMat = localPosBoneMat.m_27658_();
            worldPosBoneMat.m_27648_(new Vector3f((float)this.animatable.m_20185_(), (float)this.animatable.m_20186_(), (float)this.animatable.m_20189_()));
            bone.setWorldSpaceXform(worldPosBoneMat);
        }
        IGeoRenderer.super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public static int getPackedOverlay(Entity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((boolean)false));
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    @Nonnull
    @ApiStatus.AvailableSince(value="3.0.42")
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getWidthScale(T entity) {
        return this.widthScale;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    public ResourceLocation m_5478_(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return animatable.m_142081_().hashCode();
    }

    @Override
    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                return (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)object));
            }
            return null;
        });
    }
}

