/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoCube;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoQuad;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoVertex;
import software.bernie.ars_nouveau.geckolib3.model.provider.GeoModelProvider;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.RenderUtils;

public interface IGeoRenderer<T> {
    public void setCurrentRTB(MultiBufferSource var1);

    public MultiBufferSource getCurrentRTB();

    default public void render(GeoModel model, T animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.setCurrentRTB(renderTypeBuffer);
        this.renderEarly(animatable, matrixStackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (renderTypeBuffer != null) {
            vertexBuilder = renderTypeBuffer.m_6299_(type);
        }
        this.renderLate(animatable, matrixStackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        for (GeoBone group : model.topLevelBones) {
            this.renderRecursively(group, matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
        this.setCurrentModelRenderCycle(EModelRenderCycle.REPEATED);
    }

    default public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        this.preparePositionRotationScale(bone, stack);
        this.renderCubesOfBone(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderChildBones(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        stack.m_85849_();
    }

    default public void renderCubesOfBone(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!bone.isHidden()) {
            for (GeoCube cube : bone.childCubes) {
                stack.m_85836_();
                if (!bone.cubesAreHidden()) {
                    this.renderCube(cube, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
                stack.m_85849_();
            }
        }
    }

    default public void renderChildBones(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!bone.childBonesAreHiddenToo()) {
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    default public void preparePositionRotationScale(GeoBone bone, PoseStack stack) {
        RenderUtils.translate(bone, stack);
        RenderUtils.moveToPivot(bone, stack);
        RenderUtils.rotate(bone, stack);
        RenderUtils.scale(bone, stack);
        RenderUtils.moveBackFromPivot(bone, stack);
    }

    default public void renderCube(GeoCube cube, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        RenderUtils.moveToPivot(cube, stack);
        RenderUtils.rotate(cube, stack);
        RenderUtils.moveBackFromPivot(cube, stack);
        Matrix3f matrix3f = stack.m_85850_().m_85864_();
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            Vector3f normal = quad.normal.m_122281_();
            normal.m_122249_(matrix3f);
            if ((cube.size.m_122260_() == 0.0f || cube.size.m_122269_() == 0.0f) && normal.m_122239_() < 0.0f) {
                normal.m_122263_(-1.0f, 1.0f, 1.0f);
            }
            if ((cube.size.m_122239_() == 0.0f || cube.size.m_122269_() == 0.0f) && normal.m_122260_() < 0.0f) {
                normal.m_122263_(1.0f, -1.0f, 1.0f);
            }
            if ((cube.size.m_122239_() == 0.0f || cube.size.m_122260_() == 0.0f) && normal.m_122269_() < 0.0f) {
                normal.m_122263_(1.0f, 1.0f, -1.0f);
            }
            this.createVerticesOfQuad(quad, matrix4f, normal, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f matrix4f, Vector3f normal, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        for (GeoVertex vertex : quad.vertices) {
            Vector4f vector4f = new Vector4f(vertex.position.m_122239_(), vertex.position.m_122260_(), vertex.position.m_122269_(), 1.0f);
            vector4f.m_123607_(matrix4f);
            bufferIn.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, vertex.textureU, vertex.textureV, packedOverlayIn, packedLightIn, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
    }

    public GeoModelProvider getGeoModelProvider();

    public ResourceLocation getTextureLocation(T var1);

    default public void renderEarly(T animatable, PoseStack stackIn, float partialTicks, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            float width = this.getWidthScale(animatable);
            float height = this.getHeightScale(animatable);
            stackIn.m_85841_(width, height, width);
        }
    }

    default public void renderLate(T animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
    }

    default public RenderType getRenderType(T animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110452_((ResourceLocation)textureLocation);
    }

    default public Color getRenderColor(T animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn) {
        return Color.ofRGBA(255, 255, 255, 255);
    }

    default public Integer getUniqueID(T animatable) {
        return animatable.hashCode();
    }

    default public void setCurrentModelRenderCycle(IRenderCycle cycle) {
    }

    @Nonnull
    default public IRenderCycle getCurrentModelRenderCycle() {
        return EModelRenderCycle.INITIAL;
    }

    default public float getWidthScale(T animatable2) {
        return 1.0f;
    }

    default public float getHeightScale(T entity) {
        return 1.0f;
    }
}

