/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;

public class SpikeCacheLoader
extends CacheLoader<Long, List<SpikeFeature.EndSpike>> {
    public List<SpikeFeature.EndSpike> load(Long seed) {
        List indexes = IntStream.range(0, 10).boxed().collect(Collectors.toList());
        Collections.shuffle(indexes, new Random(seed));
        ArrayList spikes = Lists.newArrayList();
        double radius = BetterEndIslandCommon.betterEnd ? 42.0 : 54.0;
        for (int i = 0; i < 10; ++i) {
            int x = Mth.m_14107_((double)(radius * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = Mth.m_14107_((double)(radius * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = (Integer)indexes.get(i);
            int pillarRadius = 2 + index / 3;
            int pillarHeight = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            spikes.add(new SpikeFeature.EndSpike(x, z, pillarRadius, pillarHeight, isGuarded));
        }
        return spikes;
    }
}

