/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.utils.ManualOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public record EnchantmentLevel(Enchantment enchantment, int level) {
    public static final Comparator<EnchantmentLevel> COMPARATOR = Comparator.comparing(EnchantmentLevel::enchantmentID).thenComparingInt(EnchantmentLevel::level);
    public static final Comparator<EnchantmentLevel> QUARRY_ENCHANTMENT_COMPARATOR = Comparator.comparing(EnchantmentLevel::enchantment, ManualOrder.builder(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getKey(arg_0))).add(Enchantments.f_44984_).add(Enchantments.f_44986_).add(Enchantments.f_44987_).add(Enchantments.f_44985_).build()).thenComparingInt(EnchantmentLevel::level);

    public EnchantmentLevel(Map.Entry<Enchantment, Integer> entry) {
        this(entry.getKey(), (int)entry.getValue());
    }

    public EnchantmentLevel(ResourceLocation enchantmentID, int level) {
        this((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentID), level);
    }

    @Nullable
    public ResourceLocation enchantmentID() {
        return ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)this.enchantment());
    }

    public static List<EnchantmentLevel> fromItem(ItemStack stack) {
        ListTag enchantmentList = stack.m_41785_();
        if (enchantmentList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnchantmentLevel> list = new ArrayList<EnchantmentLevel>(enchantmentList.size());
        for (int i = 0; i < enchantmentList.size(); ++i) {
            CompoundTag tag = enchantmentList.m_128728_(i);
            ResourceLocation name = EnchantmentHelper.m_182446_((CompoundTag)tag);
            int level = EnchantmentHelper.m_182438_((CompoundTag)tag);
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(name)) continue;
            list.add(new EnchantmentLevel(name, level));
        }
        return list;
    }

    public static enum NoEnchantments implements HasEnchantments
    {
        INSTANCE;


        @Override
        public List<EnchantmentLevel> getEnchantments() {
            return Collections.emptyList();
        }
    }

    public static interface HasEnchantments {
        public List<EnchantmentLevel> getEnchantments();

        default public int getLevel(Enchantment enchantment) {
            return this.getEnchantments().stream().filter(e -> e.enchantment() == enchantment).mapToInt(EnchantmentLevel::level).findFirst().orElse(0);
        }

        default public int efficiencyLevel() {
            return this.getLevel(Enchantments.f_44984_);
        }

        default public int unbreakingLevel() {
            return this.getLevel(Enchantments.f_44986_);
        }

        default public int fortuneLevel() {
            return this.getLevel(Enchantments.f_44987_);
        }

        default public int silktouchLevel() {
            return this.getLevel(Enchantments.f_44985_);
        }

        default public ItemStack getPickaxe() {
            ItemStack stack = new ItemStack((ItemLike)Items.f_42395_);
            this.getEnchantments().forEach(e -> stack.m_41663_(e.enchantment(), e.level()));
            return stack;
        }
    }
}

