/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public record FluidKey(Fluid fluid, @Nullable CompoundTag nbt) {
    public FluidKey(FluidStack stack) {
        this(stack.getFluid(), stack.getTag());
    }

    public CompoundTag createNbt(long amount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("fluid", this.getId().toString());
        if (this.nbt != null) {
            tag.m_128365_("tag", (Tag)this.nbt);
        }
        tag.m_128356_("amount", amount);
        return tag;
    }

    static FluidKey fromNbt(CompoundTag tag) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("fluid")));
        CompoundTag nbt = tag.m_128441_("nbt") ? tag.m_128469_("nbt") : null;
        return new FluidKey(fluid, nbt);
    }

    public FluidStack toStack(int amount) {
        return new FluidStack(this.fluid(), amount, this.nbt());
    }

    public ResourceLocation getId() {
        return ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.fluid);
    }
}

