/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerConfig;

class MachinePowerConfig
implements PowerConfig {
    private final String machineName;
    final double maxEnergy;
    final double makeFrame;
    final double breakBlockBase;
    final double breakBlockFluid;
    final double moveHeadBase;
    final double expCollect;
    final double efficiencyCoefficient;
    final double breakEfficiencyCoefficient;
    final double breakFortuneCoefficient;
    final double breakSilktouchCoefficient;

    MachinePowerConfig(String machineName) {
        this.machineName = machineName;
        Config.PowerMap powerMap = QuarryPlus.config.powerMap;
        this.maxEnergy = powerMap.get(machineName, "maxEnergy").orElse((double)DEFAULT.maxEnergy() / 1.0E9);
        this.makeFrame = powerMap.get(machineName, "makeFrame").orElse((double)DEFAULT.makeFrame() / 1.0E9);
        this.breakBlockBase = powerMap.get(machineName, "breakBlockBase").orElse((double)DEFAULT.breakBlockBase() / 1.0E9);
        this.breakBlockFluid = powerMap.get(machineName, "breakBlockFluid").orElse((double)DEFAULT.breakBlockFluid() / 1.0E9);
        this.moveHeadBase = powerMap.get(machineName, "moveHeadBase").orElse((double)DEFAULT.moveHeadBase() / 1.0E9);
        this.expCollect = powerMap.get(machineName, "expCollect").orElse((double)DEFAULT.expCollect() / 1.0E9);
        this.efficiencyCoefficient = powerMap.get(machineName, "efficiencyCoefficient").orElse(DEFAULT.efficiencyCoefficient());
        this.breakEfficiencyCoefficient = powerMap.get(machineName, "breakEfficiencyCoefficient").orElse(DEFAULT.breakEfficiencyCoefficient());
        this.breakFortuneCoefficient = powerMap.get(machineName, "breakFortuneCoefficient").orElse(DEFAULT.breakFortuneCoefficient());
        this.breakSilktouchCoefficient = powerMap.get(machineName, "breakSilktouchCoefficient").orElse(DEFAULT.breakSilktouchCoefficient());
    }

    public String toString() {
        return "MachinePowerConfig{machineName='" + this.machineName + "'}";
    }

    @Override
    public long maxEnergy() {
        return (long)(this.maxEnergy * 1.0E9);
    }

    @Override
    public long makeFrame() {
        return (long)(this.makeFrame * 1.0E9);
    }

    @Override
    public long breakBlockBase() {
        return (long)(this.breakBlockBase * 1.0E9);
    }

    @Override
    public long breakBlockFluid() {
        return (long)(this.breakBlockFluid * 1.0E9);
    }

    @Override
    public long moveHeadBase() {
        return (long)(this.moveHeadBase * 1.0E9);
    }

    @Override
    public long expCollect() {
        return (long)(this.expCollect * 1.0E9);
    }

    @Override
    public double efficiencyCoefficient() {
        return this.efficiencyCoefficient;
    }

    @Override
    public double breakEfficiencyCoefficient() {
        return this.breakEfficiencyCoefficient;
    }

    @Override
    public double breakFortuneCoefficient() {
        return this.breakFortuneCoefficient;
    }

    @Override
    public double breakSilktouchCoefficient() {
        return this.breakSilktouchCoefficient;
    }
}

