/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.advpump.EnchantmentEfficiency;
import com.yogpc.qp.machines.advpump.ItemAdvPump;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BlockAdvPump
extends QPBlock
implements EntityBlock {
    public static final String NAME = "adv_pump";

    public BlockAdvPump() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME, ItemAdvPump::new);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.ADV_PUMP_TYPE.m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? null : BlockAdvPump.checkType(type, Holder.ADV_PUMP_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), TileAdvPump::tick, PowerTile.logTicker(), MachineStorage.passFluid()));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.f_46443_) {
                player.m_5661_((Component)new TranslatableComponent("quarryplus.chat.disable_message", new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                pump.reset();
                pump.deleteFluid = !pump.deleteFluid;
                player.m_5661_((Component)new TextComponent("AdvPump DeleteFluid: " + pump.deleteFluid), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                if (stack.m_41720_() instanceof QuarryModuleProvider.Item) {
                    ContainerQuarryModule.InteractionObject.openGUI(pump, (ServerPlayer)player, (Component)this.m_49954_());
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)pump, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileAdvPump) {
            TileAdvPump pump = (TileAdvPump)blockEntity;
            boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, pump.enabled);
            pump.setEnchantment(EnchantmentEfficiency.fromMap(EnchantmentHelper.m_44831_((ItemStack)stack)));
            pump.setChunkPreLoaded(preForced);
            pump.updateModule();
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TileAdvPump) {
                TileAdvPump pump = (TileAdvPump)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)pump.getModuleInventory());
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileAdvPump) {
            TileAdvPump pump = (TileAdvPump)blockEntity;
            EnchantedLootFunction.process(stack, pump);
        }
        return stack;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, world, pos, block, fromPos, notify);
        if (!world.f_46443_) {
            world.m_141902_(pos, Holder.ADV_PUMP_TYPE).ifPresent(TileAdvPump::updateModule);
        }
    }
}

