/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.bookmover.BookMoverMenu;
import com.yogpc.qp.utils.MapMulti;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.VisibleForTesting;

public class BookMoverEntity
extends PowerTile
implements Container,
MenuProvider,
CheckerLog {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    static final Set<EnchantmentCategory> CATEGORIES = Arrays.stream(EnchantmentCategory.values()).filter(t -> t.m_7454_(Items.f_42390_)).collect(Collectors.toSet());
    static final Set<Enchantment> VALID_ENCHANTMENTS = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> CATEGORIES.contains(e.f_44672_)).collect(Collectors.toSet());

    public BookMoverEntity(BlockPos pos, BlockState state) {
        super(Holder.BOOK_MOVER_TYPE, pos, state);
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    void workInTick() {
        if (!this.hasEnoughEnergy() || !this.isWorking()) {
            return;
        }
        if (this.getEnergy() >= this.getMaxEnergy()) {
            if (!this.m_7013_(0, (ItemStack)this.inventory.get(0)) || !this.m_7013_(1, (ItemStack)this.inventory.get(1))) {
                return;
            }
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)((ItemStack)this.inventory.get(1)));
            enchantments.entrySet().stream().filter(e -> VALID_ENCHANTMENTS.contains(e.getKey()) && EnchantmentHelper.m_44831_((ItemStack)((ItemStack)this.inventory.get(0))).keySet().stream().allMatch(e2 -> e2 == e.getKey() || e2.m_44695_((Enchantment)e.getKey())) && EnchantmentHelper.m_44843_((Enchantment)((Enchantment)e.getKey()), (ItemStack)((ItemStack)this.inventory.get(0))) < (Integer)e.getValue()).findFirst().ifPresent(e -> {
                ItemStack copy = ((ItemStack)this.inventory.get(0)).m_41777_();
                BookMoverEntity.removeEnchantment((Enchantment)e.getKey(), copy);
                copy.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue());
                if (enchantments.size() == 1) {
                    this.m_6836_(1, new ItemStack((ItemLike)Items.f_42517_));
                } else {
                    BookMoverEntity.removeEnchantment((Enchantment)e.getKey(), (ItemStack)this.inventory.get(1));
                }
                this.m_6836_(0, ItemStack.f_41583_);
                this.m_6836_(2, copy);
                this.useEnergy(this.getMaxEnergy(), PowerTile.Reason.BOOK_MOVER, false);
            });
        }
    }

    @Override
    protected long getMaxReceive() {
        if (this.isWorking()) {
            return this.getMaxEnergy() / 300L;
        }
        return 0L;
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventory, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        this.m_6596_();
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return switch (index) {
            case 0 -> stack.m_41720_() instanceof EnchantableItem;
            case 1 -> {
                if (stack.m_41720_() == Items.f_42690_) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public boolean m_6542_(Player player) {
        return BookMoverEntity.stillValid(this, player);
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of(this.energyString()).map(TextComponent::new).toList();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new BookMoverMenu(id, player, this.m_58899_());
    }

    boolean isWorking() {
        return !((ItemStack)this.inventory.get(0)).m_41619_() && !((ItemStack)this.inventory.get(1)).m_41619_();
    }

    @VisibleForTesting
    static void removeEnchantment(Enchantment enchantment, ItemStack stack) {
        String tagName;
        ListTag list;
        if (stack.m_150930_(Items.f_42690_)) {
            list = EnchantedBookItem.m_41163_((ItemStack)stack);
            tagName = "StoredEnchantments";
        } else {
            list = stack.m_41785_();
            tagName = "Enchantments";
        }
        stack.m_41749_(tagName);
        ListTag newList = list.stream().mapMulti(MapMulti.cast(CompoundTag.class)).filter(t -> !Objects.equals(EnchantmentHelper.m_182446_((CompoundTag)t), enchantment.getRegistryName())).collect(Collectors.toCollection(ListTag::new));
        stack.m_41700_(tagName, (Tag)newList);
    }
}

