/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.controller.GuiSlotEntities;
import com.yogpc.qp.machines.controller.SetSpawnerEntityMessage;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuiController
extends Screen
implements Button.OnPress {
    private static final Comparator<ResourceLocation> RESOURCE_LOCATION_COMPARATOR = Comparator.comparing(ResourceLocation::m_135827_).thenComparing(ResourceLocation::m_135815_);
    private GuiSlotEntities slot;
    private EditBox search;
    List<ResourceLocation> names;
    @NotNull
    private final List<ResourceLocation> allEntities;
    private final ResourceKey<Level> dim;
    private final BlockPos pos;

    public GuiController(ResourceKey<Level> dim, BlockPos pos, List<ResourceLocation> allEntities) {
        super((Component)Holder.BLOCK_CONTROLLER.m_49954_());
        this.dim = dim;
        this.pos = pos;
        this.allEntities = allEntities;
        this.names = allEntities.stream().sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
    }

    public void m_7856_() {
        super.m_7856_();
        int width = this.f_96543_;
        int height = this.f_96544_;
        this.slot = new GuiSlotEntities(this.getMinecraft(), width, height, 30, height - 60, 18, this);
        this.m_142416_((GuiEventListener)this.slot);
        this.m_94718_((GuiEventListener)this.slot);
        this.m_142416_((GuiEventListener)new IndexedButton(-1, width / 2 - 125, height - 26, 250, 20, (Component)new TranslatableComponent("gui.done"), this));
        this.search = new EditBox(this.f_96547_, width / 2 - 125, height - 56, 250, 20, (Component)new TextComponent("edit box"));
        this.m_142416_((GuiEventListener)this.search);
        this.search.m_94190_(true);
        this.search.m_94151_(this::searchEntities);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.slot != null) {
            this.slot.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.search.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        GuiController.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)new TranslatableComponent("yog.spawner.setting"), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.getMinecraft().f_91074_ != null && !this.getMinecraft().f_91074_.m_6084_()) {
            this.getMinecraft().f_91074_.m_6915_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.search.m_93696_() && this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_93750_(Button button) {
        IndexedButton indexedButton;
        if (button instanceof IndexedButton && (indexedButton = (IndexedButton)button).id() == -1) {
            GuiSlotEntities.Entry selected = (GuiSlotEntities.Entry)this.slot.m_93511_();
            if (selected != null) {
                PacketHandler.sendToServer(new SetSpawnerEntityMessage(this.pos, this.dim, selected.location));
            }
            if (this.getMinecraft().f_91074_ != null) {
                this.getMinecraft().f_91074_.m_6915_();
            }
        }
    }

    public void buildModList(Consumer<GuiSlotEntities.Entry> modListViewConsumer, Function<ResourceLocation, GuiSlotEntities.Entry> newEntry) {
        this.names.stream().map(newEntry).forEach(modListViewConsumer);
    }

    public void searchEntities(String text) {
        List collect;
        if (!text.isEmpty()) {
            try {
                Pattern pattern = Pattern.compile(text);
                collect = this.allEntities.stream().filter(l -> pattern.matcher(l.toString()).find()).sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
            }
            catch (PatternSyntaxException e) {
                collect = this.allEntities.stream().filter(l -> l.toString().contains(text)).sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
            }
        } else {
            collect = this.allEntities.stream().sorted(RESOURCE_LOCATION_COMPARATOR).collect(Collectors.toList());
        }
        if (this.names.size() != collect.size()) {
            this.slot.m_93410_(0.0);
        }
        this.names = collect;
        this.slot.refreshList();
        this.slot.m_6987_(null);
    }
}

