/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public final class FillerButtonMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final FillerEntity.Action action;

    FillerButtonMessage(FillerEntity filler, FillerEntity.Action action) {
        this.pos = filler.m_58899_();
        this.dim = PacketHandler.getDimension(filler);
        this.action = action;
    }

    public FillerButtonMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.action = (FillerEntity.Action)buf.m_130066_(FillerEntity.Action.class);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        buf.m_130068_((Enum)this.action);
    }

    public static void onReceive(FillerButtonMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.m_7702_(message.pos)).flatMap(MapMulti.optCast(FillerEntity.class)).ifPresent(arg_0 -> FillerButtonMessage.lambda$onReceive$2(message, (Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ void lambda$onReceive$2(FillerButtonMessage message, Supplier supplier, FillerEntity f) {
        f.start(message.action);
        if (f.fillerAction.isFinished()) {
            PacketHandler.getPlayer((NetworkEvent.Context)supplier.get()).ifPresent(p -> p.m_5661_((Component)new TextComponent("Filler work isn't started. You must place a marker near Filler."), false));
        }
    }
}

