/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.miningwell;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.miningwell.MiningWellBlock;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MiningWellTile
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage {
    private final MachineStorage storage = new MachineStorage();
    private final ItemConverter itemConverter = ItemConverter.defaultConverter();
    public int digMinY = 0;
    private int interval = 0;
    private boolean finished = false;

    public MiningWellTile(BlockPos pos, BlockState state) {
        super(Holder.MINING_WELL_TYPE, pos, state);
    }

    public void tick() {
        int y;
        assert (this.f_58857_ != null);
        assert (!this.f_58857_.f_46443_);
        if (!this.hasEnoughEnergy() || this.finished || --this.interval > 0) {
            return;
        }
        this.interval = 40;
        if (!((Boolean)this.m_58900_().m_61143_((Property)MiningWellBlock.WORKING)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(true)), 2);
            this.m_6596_();
        }
        for (y = this.m_58899_().m_123342_() - 1; y >= this.digMinY; --y) {
            BlockPos targetPos = this.m_58899_().m_175288_(y);
            BlockState state = this.f_58857_.m_8055_(targetPos);
            FluidState fluid = this.f_58857_.m_6425_(targetPos);
            if (state.m_60795_()) continue;
            ItemStack pickaxe = new ItemStack((ItemLike)Items.f_42395_);
            FakePlayer fakePlayer = QuarryFakePlayer.get((ServerLevel)this.f_58857_);
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, pickaxe);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.f_58857_, targetPos, state, (Player)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (breakEvent.isCanceled()) continue;
            if (!fluid.m_76178_()) {
                if (!this.useEnergy(PowerManager.getBreakBlockFluidEnergy(EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.REMOVE_FLUID, false)) break;
                if (state.m_60734_() instanceof LiquidBlock) {
                    if (!fluid.m_76178_() && fluid.m_76170_()) {
                        this.storage.addFluid(fluid.m_76152_(), 1000L);
                    }
                    this.f_58857_.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
                    break;
                }
                Block block = state.m_60734_();
                if (block instanceof BucketPickup) {
                    BucketPickup drain = (BucketPickup)block;
                    ItemStack bucket = drain.m_142598_((LevelAccessor)this.f_58857_, targetPos, state);
                    this.storage.addFluid(bucket);
                    break;
                }
                this.f_58857_.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
                break;
            }
            if (!this.canBreak(this.f_58857_, targetPos, state)) continue;
            this.breakBlock(this.f_58857_, targetPos, state);
            break;
        }
        if (y < this.digMinY) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MiningWellBlock.WORKING, (Comparable)Boolean.valueOf(false)), 2);
            this.m_6596_();
            this.finished = true;
        }
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.m_128365_("storage", (Tag)this.storage.toNbt());
        nbt.m_128405_("digMinY", this.digMinY);
        nbt.m_128405_("waitingTick", this.interval);
        nbt.m_128379_("finished", this.finished);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.storage.readNbt(nbt.m_128469_("storage"));
        this.digMinY = nbt.m_128451_("digMinY");
        this.interval = nbt.m_128451_("waitingTick");
        this.finished = nbt.m_128471_("finished");
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("MinY: " + this.digMinY, "Interval: " + this.interval, "Finished: " + this.finished, this.energyString()).map(TextComponent::new).toList();
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    private boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        float hardness = state.m_60800_((BlockGetter)targetWorld, targetPos);
        return hardness >= 0.0f;
    }

    private void breakBlock(Level level, BlockPos pos, BlockState state) {
        float hardness = state.m_60800_((BlockGetter)level, pos);
        if (this.useEnergy(PowerManager.getBreakEnergy(hardness, EnchantmentLevel.NoEnchantments.INSTANCE, PowerConfig.DEFAULT), PowerTile.Reason.BREAK_BLOCK, false)) {
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos), null, (ItemStack)new ItemStack((ItemLike)Items.f_42395_));
            drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            SoundType sound = state.m_60827_();
            level.m_5594_(null, pos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 4.0f, sound.m_56774_() * 0.8f);
        }
    }

    void reset() {
        this.finished = false;
        this.interval = 40;
    }
}

