/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public final class TileMessage
implements IMessage {
    private final CompoundTag tag;
    private final BlockPos pos;
    private final ResourceKey<Level> dim;

    public TileMessage(BlockPos pos, ResourceKey<Level> dim, CompoundTag tag) {
        this.tag = tag;
        this.pos = pos;
        this.dim = dim;
    }

    public TileMessage(BlockEntity entity) {
        this(entity.m_58899_(), PacketHandler.getDimension(entity), entity.m_187482_());
    }

    public TileMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_()), buf.m_130260_());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.dim.m_135782_());
        buf.m_130079_(this.tag);
    }

    public static void onReceive(TileMessage message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            throw new IllegalStateException("Message was sent to unexpected side.");
        }
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(l -> l.m_7702_(message.pos)).ifPresent(t -> t.m_142466_(message.tag)));
    }
}

