/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.yogpc.qp.render.ColorBox;

final class Buffer {
    private final VertexConsumer bufferBuilder;
    private final PoseStack matrix;
    private final Vector4f vector4f = new Vector4f();
    private final ColorBox colorBox;

    Buffer(VertexConsumer bufferBuilder, PoseStack matrixStack) {
        this(bufferBuilder, matrixStack, ColorBox.white);
    }

    Buffer(VertexConsumer bufferBuilder, PoseStack matrix, ColorBox colorBox) {
        this.bufferBuilder = bufferBuilder;
        this.matrix = matrix;
        this.colorBox = colorBox;
    }

    Buffer pos(double x, double y, double z) {
        Matrix4f matrix4f = this.matrix.m_85850_().m_85861_();
        this.vector4f.m_123602_((float)x, (float)y, (float)z, 1.0f);
        this.vector4f.m_123607_(matrix4f);
        this.bufferBuilder.m_5483_((double)this.vector4f.m_123601_(), (double)this.vector4f.m_123615_(), (double)this.vector4f.m_123616_());
        return this;
    }

    Buffer colored() {
        return this.color(this.colorBox);
    }

    Buffer color(int red, int green, int blue, int alpha) {
        this.bufferBuilder.m_6122_(red, green, blue, alpha);
        return this;
    }

    Buffer color(ColorBox colors) {
        this.bufferBuilder.m_6122_(colors.red(), colors.green(), colors.blue(), colors.alpha());
        return this;
    }

    Buffer tex(float u, float v) {
        this.bufferBuilder.m_7421_(u, v);
        return this;
    }

    void lightedAndEnd() {
        this.bufferBuilder.m_7122_(10, 10).m_7120_(240, 0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    boolean bufferEq(VertexConsumer builder) {
        return this.bufferBuilder == builder;
    }
}

