/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"modernfix").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"upgradeStructures").requires(source -> source.m_6761_(3))).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            if (level == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Couldn't find server level"));
                return 0;
            }
            CloseableResourceManager manager = level.m_142572_().f_129740_.f_206584_();
            Collection structures = manager.m_6540_("structures", p -> p.endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (ResourceLocation found : structures) {
                ++upgradedNum;
                Matcher matcher = pathPattern.matcher(found.m_135815_());
                if (!matcher.matches()) continue;
                ResourceLocation structureLocation = new ResourceLocation(found.m_135827_(), matcher.group(1));
                try {
                    Resource resource = manager.m_142591_(found);
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.m_142572_().m_129933_(), resource.m_6679_());
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("checked " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + found, e);
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("error reading " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"));
                }
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("All structures upgraded"), false);
            return 1;
        })));
    }
}

