/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra;

import mrthomas20121.thermal_extra.datagen.ExtraBlockstateGen;
import mrthomas20121.thermal_extra.datagen.ExtraLangGen;
import mrthomas20121.thermal_extra.datagen.ExtraModelGen;
import mrthomas20121.thermal_extra.datagen.ExtraRecipeGen;
import mrthomas20121.thermal_extra.datagen.ExtraTagGen;
import mrthomas20121.thermal_extra.datagen.TinkerRecipeDatagen;
import mrthomas20121.thermal_extra.filter.AdvancedFilter;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal_extra")
@Mod.EventBusSubscriber(modid="thermal_extra", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThermalExtra {
    public static final String MOD_ID = "thermal_extra";
    public static final Logger LOGGER = LogManager.getLogger();

    public ThermalExtra() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ThermalExtraItems.ITEMS.register(bus);
        ThermalExtraBlocks.BLOCKS.register(bus);
        ThermalExtraFluids.FLUIDS.register(bus);
        AdvancedFilter.init();
        bus.addListener(this::clientStuff);
    }

    public void clientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerRenderLayers);
    }

    public void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalExtraBlocks.SOUL_INFUSED_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalExtraBlocks.SHELLITE_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalExtraBlocks.TWINITE_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalExtraBlocks.DRAGONSTEEL_GLASS.get()), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            if (ModList.get().isLoaded("tconstruct")) {
                gen.m_123914_((DataProvider)new TinkerRecipeDatagen(gen));
            }
            gen.m_123914_((DataProvider)new ExtraRecipeGen(gen));
            ExtraTagGen.BlockTags blockTags = new ExtraTagGen.BlockTags(gen, fileHelper);
            gen.m_123914_((DataProvider)blockTags);
            gen.m_123914_((DataProvider)new ExtraTagGen.ItemTags(gen, blockTags, fileHelper));
            gen.m_123914_((DataProvider)new ExtraTagGen.FluidTags(gen, fileHelper));
        }
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new ExtraModelGen(gen, fileHelper));
            gen.m_123914_((DataProvider)new ExtraLangGen(gen));
            gen.m_123914_((DataProvider)new ExtraBlockstateGen(gen, fileHelper));
        }
    }
}

