/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.datagen;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mrthomas20121.thermal_extra.fluid.FluidThermalExtra;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class TinkerRecipeDatagen
extends RecipeProvider
implements IConditionBuilder,
IMaterialRecipeHelper,
IToolRecipeHelper,
ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public TinkerRecipeDatagen(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    public String getModId() {
        return "thermal_extra";
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
        String meltingFolder = "compat/tconstruct/melting/";
        String castingFolder = "compat/tconstruct/casting/";
        this.metalMelting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), (Fluid)ThermalExtraFluids.soul_infused.getStillFluid().get(), "soul_infused", false, true, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), (Fluid)ThermalExtraFluids.shellite.getStillFluid().get(), "shellite", false, true, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), (Fluid)ThermalExtraFluids.twinite.getStillFluid().get(), "twinite", false, true, meltingFolder, false, new IByproduct[0]);
        this.metalMelting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), (Fluid)ThermalExtraFluids.dragonsteel.getStillFluid().get(), "dragonsteel", false, true, meltingFolder, false, new IByproduct[0]);
        this.metalTagCasting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), ThermalExtraFluids.soul_infused, "soul_infused", castingFolder, false);
        this.metalTagCasting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), ThermalExtraFluids.shellite, "dragon_enderium", castingFolder, false);
        this.metalTagCasting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), ThermalExtraFluids.twinite, "drownium", castingFolder, false);
        this.metalTagCasting(this.withCondition(consumer, new ICondition[]{this.modLoaded("tconstruct")}), ThermalExtraFluids.dragonsteel, "dragonsteel", castingFolder, false);
    }

    private void metalTagCasting(Consumer<FinishedRecipe> consumer, FluidThermalExtra fluid, String name, String folder, boolean forceStandard) {
        this.tagCasting(consumer, fluid, 10, TinkerSmeltery.nuggetCast, "nuggets/" + name, folder + name + "/nugget", !forceStandard);
        this.tagCasting(consumer, fluid, 90, TinkerSmeltery.ingotCast, "ingots/" + name, folder + name + "/ingot", !forceStandard);
        this.tagCasting(consumer, fluid, 90, TinkerSmeltery.plateCast, "plates/" + name, folder + name + "/plate", true);
        this.tagCasting(consumer, fluid, 360, TinkerSmeltery.gearCast, "gears/" + name, folder + name + "/gear", true);
        this.tagCasting(consumer, fluid, 30, TinkerSmeltery.coinCast, "coins/" + name, folder + name + "/coin", true);
        this.tagCasting(consumer, fluid, 45, TinkerSmeltery.rodCast, "rods/" + name, folder + name + "/rod", true);
        this.tagCasting(consumer, fluid, 45, TinkerSmeltery.wireCast, "wires/" + name, folder + name + "/wire", true);
        TagKey block = this.getItemTag("forge", "storage_blocks/" + name);
        Consumer wrapped = forceStandard ? consumer : this.withCondition(consumer, new ICondition[]{this.tagCondition("storage_blocks/" + name)});
        ItemCastingRecipeBuilder.basinRecipe((TagKey)block).setFluidAndTime((Fluid)fluid.getStillFluid().get(), fluid.getFluidTag(), 810).save(wrapped, this.modResource(folder + name + "/block"));
    }

    private void tagCasting(Consumer<FinishedRecipe> consumer, FluidThermalExtra fluid, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        if (optional) {
            consumer = this.withCondition(consumer, new ICondition[]{this.tagCondition(tagName)});
        }
        this.castingWithCast(consumer, fluid, amount, cast, ItemOutput.fromTag((TagKey)this.getItemTag("forge", tagName), (int)1), recipeName);
    }

    private void castingWithCast(Consumer<FinishedRecipe> consumer, FluidThermalExtra fluid, int amount, CastItemObject cast, ItemOutput output, String location) {
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)output).setFluidAndTime((Fluid)fluid.getStillFluid().get(), fluid.getFluidTag(), amount).setCast(cast.getMultiUseTag(), false).save(consumer, this.modResource(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)output).setFluidAndTime((Fluid)fluid.getStillFluid().get(), fluid.getFluidTag(), amount).setCast(cast.getSingleUseTag(), true).save(consumer, this.modResource(location + "_sand_cast"));
    }
}

