/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.preferences.PreferencesDispatcher;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.DefaultModSetup;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;

public class ModSetup
extends DefaultModSetup {
    public static final ResourceLocation PREFERENCES_CAPABILITY_KEY = new ResourceLocation("mcjtylib", "preferences");
    public static boolean patchouli = false;
    public static Capability<PreferencesProperties> PREFERENCES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PreferencesProperties>(){});

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityContainerProvider.register(event);
        CapabilityInfusable.register(event);
        CapabilityPowerInformation.register(event);
        CapabilityModuleSupport.register(event);
        PreferencesProperties.register(event);
    }

    @Override
    public void init(FMLCommonSetupEvent e) {
        super.init(e);
        McJtyLib.networkHandler = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mcjtylib", "mcjtylib"), () -> "1.0", s -> true, s -> true);
        PacketHandler.registerMessages(McJtyLib.networkHandler);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        McJtyLib.tesla = ModList.get().isLoaded("tesla");
        McJtyLib.cofhapiitem = ModList.get().isLoaded("cofhapi|item");
    }

    @Override
    protected void setupModCompat() {
        patchouli = ModList.get().isLoaded("patchouli");
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase == TickEvent.Phase.START && event.world.m_46472_() == Level.f_46428_) {
                McJtyLib.SYNCER.sendOutData(event.world.m_142572_());
            }
        }

        @SubscribeEvent
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            McJtyLib.SYNCER.startWatching(event.getPlayer());
        }

        @SubscribeEvent
        public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && !event.player.m_20193_().f_46443_) {
                McJtyLib.getPreferencesProperties(event.player).ifPresent(handler -> handler.tick((ServerPlayer)event.player));
            }
        }

        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                if (!event.getCapabilities().containsKey(PREFERENCES_CAPABILITY_KEY) && !((Entity)event.getObject()).getCapability(PREFERENCES_CAPABILITY).isPresent()) {
                    event.addCapability(PREFERENCES_CAPABILITY_KEY, (ICapabilityProvider)new PreferencesDispatcher());
                } else {
                    throw new IllegalStateException(((Entity)event.getObject()).toString());
                }
            }
        }

        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
            BlockPos pos;
            Level world = event.getWorld();
            BlockState state = world.m_8055_(pos = event.getPos());
            if (state.m_60734_() instanceof MultipartBlock) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (tileEntity instanceof MultipartTE && !world.f_46443_) {
                    Player player = event.getPlayer();
                    Vec3 start = player.m_20299_(1.0f);
                    Vec3 vec31 = player.m_20252_(1.0f);
                    float dist = 20.0f;
                    Vec3 end = start.m_82520_(vec31.f_82479_ * (double)dist, vec31.f_82480_ * (double)dist, vec31.f_82481_ * (double)dist);
                    ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
                    BlockHitResult result = player.m_20193_().m_45547_(context);
                    Vec3 hitVec = result.m_82450_();
                    if (MultipartHelper.removePart((MultipartTE)tileEntity, state, player, hitVec)) {
                        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                }
                event.setCanceled(true);
            }
        }
    }
}

