/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.syncpositional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.syncpositional.IPositionalData;
import mcjty.lib.syncpositional.PacketSendPositionalDataToClients;
import mcjty.lib.syncpositional.PositionalDataKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;

public class PositionalDataSyncer {
    private final Map<ResourceLocation, Function<FriendlyByteBuf, IPositionalData>> factories = new HashMap<ResourceLocation, Function<FriendlyByteBuf, IPositionalData>>();
    private final Map<ResourceLocation, BiConsumer<GlobalPos, IPositionalData>> clientHandlers = new HashMap<ResourceLocation, BiConsumer<GlobalPos, IPositionalData>>();
    private final Map<ChunkPos, Map<PositionalDataKey, Runnable>> watchHandlers = Collections.synchronizedMap(new HashMap());
    private final Map<PositionalDataKey, IPositionalData> syncTodo = new HashMap<PositionalDataKey, IPositionalData>();
    private int timeout = 0;

    public void registerPositionalDataFactory(ResourceLocation id, Function<FriendlyByteBuf, IPositionalData> factory) {
        this.factories.put(id, factory);
    }

    public void registerClientHandler(ResourceLocation id, BiConsumer<GlobalPos, IPositionalData> handler) {
        this.clientHandlers.put(id, handler);
    }

    public void registerWatchHandler(ResourceLocation id, GlobalPos pos, Runnable handler) {
        ChunkPos cp = new ChunkPos(pos.m_122646_());
        Map runnableMap = this.watchHandlers.computeIfAbsent(cp, chunkPos -> new HashMap());
        PositionalDataKey dataKey = new PositionalDataKey(id, pos);
        runnableMap.put(dataKey, handler);
    }

    public void unregisterWatchHandler(ResourceLocation id, GlobalPos pos) {
        ChunkPos cp = new ChunkPos(pos.m_122646_());
        Map<PositionalDataKey, Runnable> runnableMap = this.watchHandlers.get(cp);
        if (runnableMap != null) {
            runnableMap.remove(new PositionalDataKey(id, pos));
        }
    }

    @Nullable
    public IPositionalData create(ResourceLocation id, FriendlyByteBuf buf) {
        return this.factories.getOrDefault(id, b -> null).apply(buf);
    }

    public <T extends IPositionalData> void handle(GlobalPos pos, T data) {
        this.clientHandlers.getOrDefault(data.getId(), (p, d) -> {}).accept(pos, data);
    }

    public void publish(Level world, BlockPos pos, IPositionalData data) {
        PositionalDataKey key = new PositionalDataKey(data.getId(), GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
        this.syncTodo.put(key, data);
    }

    public void forget(Level world, BlockPos pos, ResourceLocation id) {
        PositionalDataKey key = new PositionalDataKey(id, GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
        this.syncTodo.remove(key);
    }

    public void sendOutData(MinecraftServer server) {
        --this.timeout;
        if (this.timeout < 0) {
            this.timeout = 10;
            for (Map.Entry<PositionalDataKey, IPositionalData> entry : this.syncTodo.entrySet()) {
                GlobalPos pos = entry.getKey().pos();
                McJtyLib.networkHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> {
                    ServerLevel level = server.m_129880_(pos.m_122640_());
                    return (LevelChunk)level.m_46865_(pos.m_122646_());
                }), (Object)new PacketSendPositionalDataToClients(pos, entry.getValue()));
            }
            this.syncTodo.clear();
        }
    }

    public void startWatching(ServerPlayer player) {
        BlockPos blockPos = player.m_142538_();
        ChunkPos cp = new ChunkPos(blockPos);
        Map<PositionalDataKey, Runnable> runnableMap = this.watchHandlers.get(cp);
        if (runnableMap != null) {
            GlobalPos pos = GlobalPos.m_122643_((ResourceKey)player.f_19853_.m_46472_(), (BlockPos)blockPos);
            for (Map.Entry<PositionalDataKey, Runnable> entry : runnableMap.entrySet()) {
                if (!pos.equals((Object)entry.getKey().pos())) continue;
                entry.getValue().run();
            }
        }
    }
}

