/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.client.compat1202plus;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin {
    @Unique
    private static final ThreadLocal<Map<ScaleType, ScaleData>> pehkui$SCALES = ThreadLocal.withInitial(Object2ObjectLinkedOpenHashMap::new);
    @Unique
    private static final ScaleData pehkui$IDENTITY = ScaleData.Builder.create().build();
    @Unique
    private static final ThreadLocal<AABB> pehkui$BOX = new ThreadLocal();

    @Inject(method={"drawEntity(Lnet/minecraft/client/gui/DrawContext;FFILorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="HEAD")})
    private static void pehkui$drawEntity$head(@Coerce Object drawContext, float x, float y, int size, @Coerce Object offset, @Coerce Object quaternionf, @Nullable @Coerce Object quaternionf2, LivingEntity entity, CallbackInfo info) {
        Map<ScaleType, ScaleData> scales = pehkui$SCALES.get();
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData cachedData = scales.computeIfAbsent(type, t -> ScaleData.Builder.create().type((ScaleType)t).build());
            ScaleData data = type.getScaleData((Entity)entity);
            cachedData.fromScale(data, false);
            data.fromScale(pehkui$IDENTITY, false);
        }
        pehkui$BOX.set(entity.m_142469_());
        EntityDimensions dims = entity.m_6972_(entity.m_20089_());
        Vec3 pos = entity.m_20182_();
        double r = (double)dims.f_20377_ / 2.0;
        double h = dims.f_20378_;
        double xPos = pos.f_82479_;
        double yPos = pos.f_82480_;
        double zPos = pos.f_82481_;
        AABB box = new AABB(xPos - r, yPos, zPos - r, xPos + r, yPos + h, zPos + r);
        entity.m_20011_(box);
    }

    @Inject(method={"drawEntity(Lnet/minecraft/client/gui/DrawContext;FFILorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private static void pehkui$drawEntity$return(@Coerce Object drawContext, float x, float y, int size, @Coerce Object offset, @Coerce Object quaternionf, @Nullable @Coerce Object quaternionf2, LivingEntity entity, CallbackInfo info) {
        Map<ScaleType, ScaleData> scales = pehkui$SCALES.get();
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData((Entity)entity).fromScale(scales.get(type), false);
        }
        entity.m_20011_(pehkui$BOX.get());
    }

    @Redirect(method={"drawEntity(Lnet/minecraft/client/gui/DrawContext;IIIIIFFFLnet/minecraft/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getHeight()F"))
    private static float pehkui$drawEntity$getHeight(LivingEntity obj) {
        float value = obj.m_20206_();
        float scale = ScaleUtils.getBoundingBoxHeightScale((Entity)obj);
        return scale != 1.0f ? ScaleUtils.divideClamped(value, scale) : value;
    }
}

