/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.capability.ISpawnTracker;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.crafting.condition.LCCraftingConditions;
import io.github.lightman314.lightmanscurrency.common.entity.merchant.villager.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.entity.merchant.villager.VillagerTradeManager;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TextNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.taxes.TaxesCollectedNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.taxes.TaxesPaidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxReferenceType;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.types.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataBook;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataTicket;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.BasicSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import io.github.lightman314.lightmanscurrency.integration.biomesoplenty.BOPCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.byg.BYGCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.discord.LCDiscord;
import io.github.lightman314.lightmanscurrency.integration.ftbchunks.LCFTBChunksIntegration;
import io.github.lightman314.lightmanscurrency.integration.immersiveengineering.LCImmersive;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isCuriosLoaded() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean isCuriosValid(LivingEntity player) {
        try {
            if (LightmansCurrency.isCuriosLoaded()) {
                return LCCurios.hasWalletSlot(player);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public LightmansCurrency() {
        LightmansCurrency.LogDebug("Initializing LightmansCurrency!");
        LootManager.registerDroplistListeners();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imc);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IntegrationUtil.SafeRunIfLoaded("biomesoplenty", BOPCustomWoodTypes::setupWoodTypes, "Error setting up BOP wood types! BOP has probably changed their API!");
        IntegrationUtil.SafeRunIfLoaded("byg", BYGCustomWoodTypes::setupWoodTypes, "Error setting up BYG wood types! BYG has probably changed their API!");
        ModRegistries.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        IntegrationUtil.SafeRunIfLoaded("lightmansdiscord", LCDiscord::setup, null);
        IntegrationUtil.SafeRunIfLoaded("ftbchunks", LCFTBChunksIntegration::setup, null);
        IntegrationUtil.SafeRunIfLoaded("immersiveengineering", LCImmersive::registerRotationBlacklists, null);
    }

    private void imc(InterModEnqueueEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, "", IntegrationUtil.SafeEnqueueWork("curios", this::curiosIMC, "Error during LC ==> Curios Inter-mod Communications!"));
    }

    private void curiosIMC() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("wallet").icon(WalletSlot.EMPTY_WALLET_SLOT).size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charm").size(1).build());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork(event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork(FMLCommonSetupEvent event) {
        LightmansCurrencyPacketHandler.init();
        LCCraftingConditions.register();
        TraderData.register(ItemTraderData.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)ItemTraderData::new));
        TraderData.register(ItemTraderDataArmor.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)ItemTraderDataArmor::new));
        TraderData.register(ItemTraderDataTicket.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)ItemTraderDataTicket::new));
        TraderData.register(ItemTraderDataBook.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)ItemTraderDataBook::new));
        TraderData.register(SlotMachineTraderData.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)SlotMachineTraderData::new));
        TraderData.register(PaygateTraderData.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)PaygateTraderData::new));
        TraderData.register(AuctionHouseTrader.TYPE, (NonNullSupplier<TraderData>)((NonNullSupplier)AuctionHouseTrader::new));
        ModGameRules.registerRules();
        TradeRule.RegisterDeserializer(PlayerWhitelist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerWhitelist::new));
        TradeRule.RegisterDeserializer(PlayerBlacklist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerBlacklist::new));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)PlayerTradeLimit::new));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)PlayerTradeLimit::new), true);
        TradeRule.RegisterDeserializer(PlayerDiscounts.TYPE, (Supplier<TradeRule>)((Supplier)PlayerDiscounts::new));
        TradeRule.RegisterDeserializer(TimedSale.TYPE, (Supplier<TradeRule>)((Supplier)TimedSale::new));
        TradeRule.RegisterDeserializer(TradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)TradeLimit::new));
        TradeRule.RegisterDeserializer(TradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)TradeLimit::new), true);
        TradeRule.RegisterDeserializer(FreeSample.TYPE, (Supplier<TradeRule>)((Supplier)FreeSample::new));
        TradeRule.RegisterDeserializer(PriceFluctuation.TYPE, (Supplier<TradeRule>)((Supplier)PriceFluctuation::new));
        Notification.register(ItemTradeNotification.TYPE, ItemTradeNotification::new);
        Notification.register(PaygateNotification.TYPE, PaygateNotification::new);
        Notification.register(SlotMachineTradeNotification.TYPE, SlotMachineTradeNotification::new);
        Notification.register(OutOfStockNotification.TYPE, OutOfStockNotification::new);
        Notification.register(LowBalanceNotification.TYPE, LowBalanceNotification::new);
        Notification.register(AuctionHouseSellerNotification.TYPE, AuctionHouseSellerNotification::new);
        Notification.register(AuctionHouseBuyerNotification.TYPE, AuctionHouseBuyerNotification::new);
        Notification.register(AuctionHouseSellerNobidNotification.TYPE, AuctionHouseSellerNobidNotification::new);
        Notification.register(AuctionHouseBidNotification.TYPE, AuctionHouseBidNotification::new);
        Notification.register(AuctionHouseCancelNotification.TYPE, AuctionHouseCancelNotification::new);
        Notification.register(TextNotification.TYPE, TextNotification::new);
        Notification.register(AddRemoveAllyNotification.TYPE, AddRemoveAllyNotification::new);
        Notification.register(AddRemoveTradeNotification.TYPE, AddRemoveTradeNotification::new);
        Notification.register(ChangeAllyPermissionNotification.TYPE, ChangeAllyPermissionNotification::new);
        Notification.register(ChangeCreativeNotification.TYPE, ChangeCreativeNotification::new);
        Notification.register(ChangeNameNotification.TYPE, ChangeNameNotification::new);
        Notification.register(ChangeOwnerNotification.TYPE, ChangeOwnerNotification::new);
        Notification.register(ChangeSettingNotification.SIMPLE_TYPE, ChangeSettingNotification.Simple::new);
        Notification.register(ChangeSettingNotification.ADVANCED_TYPE, ChangeSettingNotification.Advanced::new);
        Notification.register(DepositWithdrawNotification.PLAYER_TYPE, DepositWithdrawNotification.Player::new);
        Notification.register(DepositWithdrawNotification.TRADER_TYPE, DepositWithdrawNotification.Trader::new);
        Notification.register(DepositWithdrawNotification.SERVER_TYPE, DepositWithdrawNotification.Server::new);
        Notification.register(BankTransferNotification.TYPE, BankTransferNotification::new);
        Notification.register(TaxesCollectedNotification.TYPE, TaxesCollectedNotification::new);
        Notification.register(TaxesPaidNotification.TYPE, TaxesPaidNotification::new);
        NotificationCategory.registerInstance(NotificationCategory.GENERAL_TYPE, NotificationCategory.GENERAL);
        NotificationCategory.registerInstance(NullCategory.TYPE, NullCategory.INSTANCE);
        NotificationCategory.register(TraderCategory.TYPE, TraderCategory::new);
        NotificationCategory.register(BankCategory.TYPE, BankCategory::new);
        NotificationCategory.registerInstance(AuctionHouseCategory.TYPE, AuctionHouseCategory.INSTANCE);
        NotificationCategory.register(TaxEntryCategory.TYPE, TaxEntryCategory::new);
        TraderSearchFilter.addFilter(new BasicSearchFilter());
        TraderSearchFilter.addFilter(new ItemTraderSearchFilter());
        TaxReferenceType.register(TaxableTraderReference.TYPE);
        BankReferenceType.register(PlayerBankReference.TYPE);
        BankReferenceType.register(TeamBankReference.TYPE);
        MenuValidatorType.register(SimpleValidator.TYPE);
        MenuValidatorType.register(BlockEntityValidator.TYPE);
        MenuValidatorType.register(BlockValidator.TYPE);
        MinecraftForge.EVENT_BUS.post((Event)new UpgradeType.RegisterUpgradeTypeEvent());
        ModCreativeGroups.setupCreativeTabs();
        ATMIconData.init();
        ItemTradeRestriction.init();
        VillagerTradeManager.registerDefaultTrades();
        ItemListingSerializer.registerDefaultSerializers();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", PROXY::setupClient);
    }

    private void onConfigLoad(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MODID) && event.getConfig().getSpec() == Config.commonSpec) {
            LootManager.validateEntityDropList();
            LootManager.debugLootConfigs();
            Config.reloadVillagerOverrides();
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IWalletHandler.class);
        event.register(ISpawnTracker.class);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
        SPacketSyncTime.syncWith(target);
        LCAdminMode.sendSyncPacket(target);
    }

    public static ItemStack getWalletStack(Player player) {
        if (player == null) {
            return ItemStack.f_41583_;
        }
        ItemStack wallet = ItemStack.f_41583_;
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
        if (walletHandler != null) {
            wallet = walletHandler.getWallet();
        }
        if (!WalletItem.validWalletStack(wallet)) {
            LightmansCurrency.LogDebug(player.m_7755_().getString() + "'s equipped wallet is not a valid WalletItem.");
            LightmansCurrency.LogDebug("Equipped wallet is of type " + wallet.m_41720_().getClass().getName());
            return ItemStack.f_41583_;
        }
        return wallet;
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogDebug(String message, Object ... objects) {
        LOGGER.debug(message, objects);
    }

    public static void LogInfo(String message) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogInfo(String message, Object ... objects) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message, objects);
        } else {
            LOGGER.info(message, objects);
        }
    }

    public static void LogWarning(String message) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogWarning(String message, Object ... objects) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message, objects);
        } else {
            LOGGER.warn(message, objects);
        }
    }

    public static void LogError(String message) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if (Config.commonSpec.isLoaded() && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    public static <T extends ParallelDispatchEvent> void safeEnqueueWork(T event, String errorMessage, Consumer<T> work) {
        event.enqueueWork(() -> {
            try {
                work.accept(event);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }
}

