/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.data;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEjectionData {
    private static final List<EjectionData> emergencyEjectionData = new ArrayList<EjectionData>();

    public static List<EjectionData> GetEjectionData() {
        return new ArrayList<EjectionData>(emergencyEjectionData);
    }

    public static void UpdateEjectionData(CompoundTag compound) {
        emergencyEjectionData.clear();
        ListTag ejectionList = compound.m_128437_("EmergencyEjectionData", 10);
        for (int i = 0; i < ejectionList.size(); ++i) {
            try {
                EjectionData e = EjectionData.loadData(ejectionList.m_128728_(i));
                if (e == null) {
                    throw new RuntimeException("EmergencyEjectionData entry " + i + " loaded as null.");
                }
                emergencyEjectionData.add(e);
                e.flagAsClient();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        LightmansCurrency.LogDebug("Client loaded " + emergencyEjectionData.size() + " ejection data entries from the server.");
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        emergencyEjectionData.clear();
    }
}

