/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.easy;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class EasyScreen
extends Screen
implements IEasyScreen {
    private final List<IPreRender> preRenders = new ArrayList<IPreRender>();
    private final List<IEasyTickable> guiTickers = new ArrayList<IEasyTickable>();
    private final List<ITooltipSource> tooltipSources = new ArrayList<ITooltipSource>();
    private final List<IScrollListener> scrollListeners = new ArrayList<IScrollListener>();
    private final List<IMouseListener> mouseListeners = new ArrayList<IMouseListener>();
    private ScreenArea screenArea = ScreenArea.of(0, 0, 100, 100);

    @Override
    public final Font getFont() {
        return this.f_96547_;
    }

    @Override
    public final Player getPlayer() {
        return this.f_96541_.f_91074_;
    }

    protected EasyScreen() {
        this((Component)EasyText.empty());
    }

    protected EasyScreen(Component title) {
        super(title);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public final ScreenArea getArea() {
        return this.screenArea;
    }

    @Override
    public final int getGuiLeft() {
        return this.screenArea.x;
    }

    @Override
    public final int getGuiTop() {
        return this.screenArea.y;
    }

    @Override
    public final ScreenPosition getCorner() {
        return this.screenArea.pos;
    }

    @Override
    public final int getXSize() {
        return this.screenArea.width;
    }

    @Override
    public final int getYSize() {
        return this.screenArea.height;
    }

    protected final void resize(int width, int height) {
        this.screenArea = this.screenArea.ofSize(width, height);
        this.recalculateCorner();
    }

    protected final void m_7856_() {
        this.preRenders.clear();
        this.guiTickers.clear();
        this.tooltipSources.clear();
        this.scrollListeners.clear();
        this.mouseListeners.clear();
        super.m_7856_();
        this.recalculateCorner();
        this.initialize(this.screenArea);
    }

    protected void recalculateCorner() {
        this.screenArea = this.screenArea.atPosition(ScreenPosition.of((this.f_96543_ - this.screenArea.width) / 2, (this.f_96544_ - this.screenArea.height) / 2));
    }

    protected abstract void initialize(ScreenArea var1);

    public final void m_6305_(@Nonnull PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.renderTick();
        EasyGuiGraphics gui = EasyGuiGraphics.create(pose, this.f_96547_, mouseX, mouseY, partialTicks).pushOffset(this.getCorner());
        for (IPreRender r : ImmutableList.copyOf(this.preRenders)) {
            r.preRender(gui);
        }
        this.m_7333_(pose);
        this.renderBG(gui);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.renderAfterWidgets(gui);
        EasyScreenHelper.RenderTooltips(gui, (List<ITooltipSource>)ImmutableList.copyOf(this.tooltipSources));
        this.renderAfterTooltips(gui);
    }

    protected void renderTick() {
    }

    protected abstract void renderBG(@Nonnull EasyGuiGraphics var1);

    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
    }

    protected void renderAfterTooltips(@Nonnull EasyGuiGraphics gui) {
    }

    public final <T> T addChild(T child) {
        EasyWidget w;
        IPreRender r;
        Object l;
        ITooltipSource t;
        IEasyTickable ticker;
        if (child instanceof EasyWidgetWithChildren) {
            EasyWidgetWithChildren w2 = (EasyWidgetWithChildren)((Object)child);
            w2.pairWithScreen(this::addChild, this::removeChild);
            if (w2.addChildrenBeforeThis()) {
                w2.addChildren();
            }
        }
        if (child instanceof Widget) {
            Widget r2 = (Widget)child;
            if (!this.f_169369_.contains(child)) {
                this.f_169369_.add(r2);
            }
        }
        if (child instanceof GuiEventListener && child instanceof NarratableEntry) {
            super.m_7787_((GuiEventListener)((NarratableEntry)child));
        }
        if ((ticker = EasyScreenHelper.getWidgetTicker(child)) != null && !this.guiTickers.contains(ticker)) {
            this.guiTickers.add(ticker);
        }
        if (child instanceof ITooltipSource && !this.tooltipSources.contains(t = (ITooltipSource)child)) {
            this.tooltipSources.add(t);
        }
        if (child instanceof IMouseListener && !this.mouseListeners.contains(l = (IMouseListener)child)) {
            this.mouseListeners.add((IMouseListener)l);
        }
        if (child instanceof IScrollListener && !this.scrollListeners.contains(l = (IScrollListener)child)) {
            this.scrollListeners.add((IScrollListener)l);
        }
        if (child instanceof IPreRender && !this.preRenders.contains(r = (IPreRender)child)) {
            this.preRenders.add(r);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            w.addAddons(this::addChild);
        }
        if (child instanceof EasyWidgetWithChildren && !((EasyWidgetWithChildren)(w = (EasyWidgetWithChildren)((Object)child))).addChildrenBeforeThis()) {
            ((EasyWidgetWithChildren)w).addChildren();
        }
        return child;
    }

    @Override
    public final void removeChild(Object child) {
        EasyWidget w;
        Object l;
        if (child instanceof Widget) {
            Widget r = (Widget)child;
            this.f_169369_.remove(r);
        }
        if (child instanceof GuiEventListener) {
            GuiEventListener l2 = (GuiEventListener)child;
            super.m_169411_(l2);
        }
        IEasyTickable ticker = EasyScreenHelper.getWidgetTicker(child);
        this.guiTickers.remove(ticker);
        if (child instanceof ITooltipSource) {
            ITooltipSource t = (ITooltipSource)child;
            this.tooltipSources.remove(t);
        }
        if (child instanceof IMouseListener) {
            l = (IMouseListener)child;
            this.mouseListeners.remove(l);
        }
        if (child instanceof IScrollListener) {
            l = (IScrollListener)child;
            this.scrollListeners.remove(l);
        }
        if (child instanceof EasyWidget) {
            w = (EasyWidget)((Object)child);
            w.removeAddons(this::removeChild);
        }
        if (child instanceof IPreRender) {
            IPreRender r = (IPreRender)child;
            this.preRenders.remove(r);
        }
        if (child instanceof EasyWidgetWithChildren) {
            w = (EasyWidgetWithChildren)((Object)child);
            ((EasyWidgetWithChildren)w).removeChildren();
        }
    }

    public final void m_96624_() {
        super.m_96624_();
        for (IEasyTickable t : ImmutableList.copyOf(this.guiTickers)) {
            t.tick();
        }
        this.screenTick();
    }

    protected void screenTick() {
    }

    @Nonnull
    @Deprecated
    protected final <T extends GuiEventListener & NarratableEntry> T m_7787_(@Nonnull T widget) {
        return (T)((GuiEventListener)this.addChild(widget));
    }

    @Nonnull
    @Deprecated
    protected final <T extends GuiEventListener & Widget> T m_142416_(@Nonnull T widget) {
        return (T)((GuiEventListener)this.addChild(widget));
    }

    @Nonnull
    @Deprecated
    protected final <T extends Widget> T m_169394_(@Nonnull T widget) {
        return this.addChild(widget);
    }

    @Deprecated
    protected final void m_169411_(@Nonnull GuiEventListener widget) {
        this.removeChild(widget);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        for (IScrollListener l : ImmutableList.copyOf(this.scrollListeners)) {
            if (!l.mouseScrolled(mouseX, mouseY, scroll)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (IMouseListener l : ImmutableList.copyOf(this.mouseListeners)) {
            if (!l.onMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_97765_, (int)p_97766_);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.blockInventoryClosing()) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_97765_, p_97766_, p_97767_);
    }
}

